/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.math;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.math.MathFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.List;

public class ChnFunction
extends MathFunction {
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_UNIT = new String[]{"", "", "\u70b9", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int NUMBER_PRECISION = 2;
    private static final String CN_ZEOR = "\u96f6";

    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        BigDecimal data = this.buildBigDecimal(dataList);
        return ChnFunction.numberToChn(data);
    }

    @Override
    public String name() {
        return "chn";
    }

    public static void main(String[] args) {
        BigDecimal numberData = new BigDecimal(30010.12);
        String chn = ChnFunction.numberToChn(numberData);
        System.out.println(chn);
    }

    private static String numberToChn(BigDecimal numberData) {
        StringBuilder sb = new StringBuilder();
        int signum = numberData.signum();
        if (signum == 0) {
            return CN_ZEOR;
        }
        long number = numberData.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            String unit;
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_UNIT[10]);
                }
                unit = ChnFunction.buildPoint(numIndex, sb);
                sb.insert(0, unit);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero && !(unit = CN_UPPER_UNIT[numIndex]).equals("\u70b9")) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        unit = ChnFunction.buildPoint(numIndex, sb);
                        sb.insert(0, unit);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        return sb.toString();
    }

    private static String buildPoint(int numIndex, StringBuilder sb) {
        String unit = CN_UPPER_UNIT[numIndex];
        if (unit.equals("\u70b9")) {
            if (sb.length() > 0) {
                return unit;
            }
        } else {
            return unit;
        }
        return "";
    }
}

