/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.date;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.date.CalendarFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.Calendar;
import java.util.List;

public class WeekFunction
extends CalendarFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        boolean isFirstSunday;
        Calendar c = this.buildCalendar(dataList);
        int weekDay = c.get(7);
        boolean bl = isFirstSunday = c.getFirstDayOfWeek() == 1;
        if (isFirstSunday && --weekDay == 0) {
            weekDay = 7;
        }
        switch (weekDay) {
            case 1: {
                return "\u661f\u671f\u4e00";
            }
            case 2: {
                return "\u661f\u671f\u4e8c";
            }
            case 3: {
                return "\u661f\u671f\u4e09";
            }
            case 4: {
                return "\u661f\u671f\u56db";
            }
            case 5: {
                return "\u661f\u671f\u4e94";
            }
            case 6: {
                return "\u661f\u671f\u516d";
            }
            case 7: {
                return "\u661f\u671f\u65e5";
            }
        }
        throw new ReportComputeException("Unknow week day :" + weekDay);
    }

    @Override
    public String name() {
        return "week";
    }
}

