/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.excel.low;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.excel.low.CellStyleContext;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Image;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import com.bstek.ureport.utils.ImageUtils;
import com.bstek.ureport.utils.UnitUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;

public class Excel97Producer {
    public void produceWithPaging(Report report, OutputStream outputStream) {
        this.doProduce(report, outputStream, true, false);
    }

    public void produce(Report report, OutputStream outputStream) {
        this.doProduce(report, outputStream, false, false);
    }

    public void produceWithSheet(Report report, OutputStream outputStream) {
        this.doProduce(report, outputStream, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProduce(Report report, OutputStream outputStream, boolean withPaging, boolean withSheet) {
        CellStyleContext cellStyleContext = new CellStyleContext();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCreationHelper creationHelper = wb.getCreationHelper();
        Paper paper = report.getPaper();
        try {
            List<Column> columns = report.getColumns();
            Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
            int columnSize = columns.size();
            if (withPaging) {
                List<Page> pages = report.getPages();
                int rowNumber = 0;
                int pageIndex = 1;
                Sheet sheet = null;
                for (Page page : pages) {
                    if (withSheet) {
                        sheet = this.createSheet(wb, paper, "\u7b2c" + pageIndex + "\u9875");
                        rowNumber = 0;
                    } else if (sheet == null) {
                        sheet = this.createSheet(wb, paper, null);
                    }
                    ++pageIndex;
                    Drawing drawing = sheet.createDrawingPatriarch();
                    List<Row> rows = page.getRows();
                    for (Row r : rows) {
                        org.apache.poi.ss.usermodel.Row row = sheet.getRow(rowNumber);
                        if (row == null) {
                            row = sheet.createRow(rowNumber);
                        }
                        Map<Column, Cell> colCell = cellMap.get(r);
                        for (int i = 0; i < columnSize; ++i) {
                            Object obj;
                            Column col = columns.get(i);
                            int w = col.getWidth();
                            if (w < 1) continue;
                            double colWidth = (double)UnitUtils.pointToPixel(w) * 37.5;
                            sheet.setColumnWidth(i, (int)((short)colWidth));
                            org.apache.poi.ss.usermodel.Cell cell = row.getCell(i);
                            if (cell != null) continue;
                            cell = row.createCell(i);
                            Cell cellInfo = colCell.get(col);
                            if (cellInfo == null) continue;
                            HSSFCellStyle style = cellStyleContext.produceXSSFCellStyle(wb, cellInfo);
                            int colSpan = cellInfo.getColSpan();
                            int rowSpan = cellInfo.getPageRowSpan();
                            int rowStart = rowNumber;
                            int rowEnd = rowSpan;
                            if (rowSpan == 0) {
                                ++rowEnd;
                            }
                            rowEnd += rowNumber;
                            int colStart = i;
                            int colEnd = colSpan;
                            if (colSpan == 0) {
                                ++colEnd;
                            }
                            colEnd += i;
                            for (int j = rowStart; j < rowEnd; ++j) {
                                org.apache.poi.ss.usermodel.Row rr = sheet.getRow(j);
                                if (rr == null) {
                                    rr = sheet.createRow(j);
                                }
                                for (int c = colStart; c < colEnd; ++c) {
                                    org.apache.poi.ss.usermodel.Cell cc = rr.getCell(c);
                                    if (cc == null) {
                                        cc = rr.createCell(c);
                                    }
                                    cc.setCellStyle((CellStyle)style);
                                }
                            }
                            if (colSpan > 0 || rowSpan > 0) {
                                if (rowSpan > 0) {
                                    --rowSpan;
                                }
                                if (colSpan > 0) {
                                    --colSpan;
                                }
                                CellRangeAddress cellRegion = new CellRangeAddress(rowNumber, rowNumber + rowSpan, i, i + colSpan);
                                sheet.addMergedRegion(cellRegion);
                            }
                            if ((obj = cellInfo.getFormatData()) == null) continue;
                            if (obj instanceof String) {
                                cell.setCellValue((String)obj);
                                cell.setCellType(CellType.STRING);
                                continue;
                            }
                            if (obj instanceof Number) {
                                BigDecimal bigDecimal = Utils.toBigDecimal(obj);
                                cell.setCellValue((double)bigDecimal.floatValue());
                                cell.setCellType(CellType.NUMERIC);
                                continue;
                            }
                            if (obj instanceof Boolean) {
                                cell.setCellValue(((Boolean)obj).booleanValue());
                                cell.setCellType(CellType.BOOLEAN);
                                continue;
                            }
                            if (obj instanceof Image) {
                                Image img = (Image)obj;
                                InputStream inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                                BufferedImage bufferedImage = ImageIO.read(inputStream);
                                int width = bufferedImage.getWidth();
                                int height = bufferedImage.getHeight();
                                IOUtils.closeQuietly((InputStream)inputStream);
                                inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                                try {
                                    XSSFClientAnchor anchor = (XSSFClientAnchor)creationHelper.createClientAnchor();
                                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                                    int pictureFormat = this.buildImageFormat(img);
                                    int pictureIndex = wb.addPicture(bytes, pictureFormat);
                                    anchor.setCol1(i);
                                    anchor.setCol2(i + colSpan);
                                    anchor.setRow1(rowNumber);
                                    anchor.setRow2(rowNumber + rowSpan);
                                    anchor.setDx1(0);
                                    anchor.setDx2(width * 9525);
                                    anchor.setDy1(0);
                                    anchor.setDy2(height * 9525);
                                    drawing.createPicture((ClientAnchor)anchor, pictureIndex);
                                    continue;
                                }
                                finally {
                                    IOUtils.closeQuietly((InputStream)inputStream);
                                }
                            }
                            if (obj instanceof ChartData) {
                                ChartData chartData = (ChartData)obj;
                                String base64Data = chartData.retriveBase64Data();
                                if (base64Data == null) continue;
                                Image img = new Image(base64Data, chartData.getWidth(), chartData.getHeight());
                                InputStream inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                                BufferedImage bufferedImage = ImageIO.read(inputStream);
                                int width = bufferedImage.getWidth();
                                int height = bufferedImage.getHeight();
                                IOUtils.closeQuietly((InputStream)inputStream);
                                inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                                try {
                                    XSSFClientAnchor anchor = (XSSFClientAnchor)creationHelper.createClientAnchor();
                                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                                    int pictureFormat = this.buildImageFormat(img);
                                    int pictureIndex = wb.addPicture(bytes, pictureFormat);
                                    anchor.setCol1(i);
                                    anchor.setCol2(i + colSpan);
                                    anchor.setRow1(rowNumber);
                                    anchor.setRow2(rowNumber + rowSpan);
                                    anchor.setDx1(0);
                                    anchor.setDx2(width * 9525);
                                    anchor.setDy1(0);
                                    anchor.setDy2(height * 9525);
                                    drawing.createPicture((ClientAnchor)anchor, pictureIndex);
                                    continue;
                                }
                                finally {
                                    IOUtils.closeQuietly((InputStream)inputStream);
                                }
                            }
                            if (!(obj instanceof Date)) continue;
                            cell.setCellValue((Date)obj);
                        }
                        row.setHeight((short)UnitUtils.pointToTwip(r.getHeight()));
                        ++rowNumber;
                    }
                    sheet.setRowBreak(rowNumber - 1);
                }
            } else {
                Sheet sheet = this.createSheet(wb, paper, null);
                Drawing drawing = sheet.createDrawingPatriarch();
                List<Row> rows = report.getRows();
                int rowNumber = 0;
                for (Row r : rows) {
                    int realHeight = r.getRealHeight();
                    if (realHeight < 1) continue;
                    if (r.isForPaging()) {
                        return;
                    }
                    org.apache.poi.ss.usermodel.Row row = sheet.getRow(rowNumber);
                    if (row == null) {
                        row = sheet.createRow(rowNumber);
                    }
                    Map<Column, Cell> colCell = cellMap.get(r);
                    for (int i = 0; i < columnSize; ++i) {
                        Object obj;
                        Column col = columns.get(i);
                        int w = col.getWidth();
                        if (w < 1) continue;
                        double colWidth = (double)UnitUtils.pointToPixel(w) * 37.5;
                        sheet.setColumnWidth(i, (int)((short)colWidth));
                        org.apache.poi.ss.usermodel.Cell cell = row.getCell(i);
                        if (cell != null) continue;
                        cell = row.createCell(i);
                        Cell cellInfo = colCell.get(col);
                        if (cellInfo == null || cellInfo.isForPaging()) continue;
                        HSSFCellStyle style = cellStyleContext.produceXSSFCellStyle(wb, cellInfo);
                        int colSpan = cellInfo.getColSpan();
                        int rowSpan = cellInfo.getRowSpan();
                        int rowStart = rowNumber;
                        int rowEnd = rowSpan;
                        if (rowSpan == 0) {
                            ++rowEnd;
                        }
                        rowEnd += rowNumber;
                        int colStart = i;
                        int colEnd = colSpan;
                        if (colSpan == 0) {
                            ++colEnd;
                        }
                        colEnd += i;
                        for (int j = rowStart; j < rowEnd; ++j) {
                            org.apache.poi.ss.usermodel.Row rr = sheet.getRow(j);
                            if (rr == null) {
                                rr = sheet.createRow(j);
                            }
                            for (int c = colStart; c < colEnd; ++c) {
                                org.apache.poi.ss.usermodel.Cell cc = rr.getCell(c);
                                if (cc == null) {
                                    cc = rr.createCell(c);
                                }
                                cc.setCellStyle((CellStyle)style);
                            }
                        }
                        if (colSpan > 0 || rowSpan > 0) {
                            if (rowSpan > 0) {
                                --rowSpan;
                            }
                            if (colSpan > 0) {
                                --colSpan;
                            }
                            CellRangeAddress cellRegion = new CellRangeAddress(rowNumber, rowNumber + rowSpan, i, i + colSpan);
                            sheet.addMergedRegion(cellRegion);
                        }
                        if ((obj = cellInfo.getFormatData()) == null) continue;
                        if (obj instanceof String) {
                            cell.setCellValue((String)obj);
                            cell.setCellType(CellType.STRING);
                            continue;
                        }
                        if (obj instanceof Number) {
                            BigDecimal bigDecimal = Utils.toBigDecimal(obj);
                            cell.setCellValue((double)bigDecimal.floatValue());
                            cell.setCellType(CellType.NUMERIC);
                            continue;
                        }
                        if (obj instanceof Boolean) {
                            cell.setCellValue(((Boolean)obj).booleanValue());
                            cell.setCellType(CellType.BOOLEAN);
                            continue;
                        }
                        if (obj instanceof Image) {
                            Image img = (Image)obj;
                            InputStream inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                            BufferedImage bufferedImage = ImageIO.read(inputStream);
                            int width = bufferedImage.getWidth();
                            int height = bufferedImage.getHeight();
                            IOUtils.closeQuietly((InputStream)inputStream);
                            inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                            try {
                                XSSFClientAnchor anchor = (XSSFClientAnchor)creationHelper.createClientAnchor();
                                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                                int pictureFormat = this.buildImageFormat(img);
                                int pictureIndex = wb.addPicture(bytes, pictureFormat);
                                anchor.setCol1(i);
                                anchor.setCol2(i + colSpan);
                                anchor.setRow1(rowNumber);
                                anchor.setRow2(rowNumber + rowSpan);
                                anchor.setDx1(0);
                                anchor.setDx2(width * 9525);
                                anchor.setDy1(0);
                                anchor.setDy2(height * 9525);
                                drawing.createPicture((ClientAnchor)anchor, pictureIndex);
                                continue;
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)inputStream);
                            }
                        }
                        if (obj instanceof ChartData) {
                            ChartData chartData = (ChartData)obj;
                            String base64Data = chartData.retriveBase64Data();
                            if (base64Data == null) continue;
                            Image img = new Image(base64Data, chartData.getWidth(), chartData.getHeight());
                            InputStream inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                            BufferedImage bufferedImage = ImageIO.read(inputStream);
                            int width = bufferedImage.getWidth();
                            int height = bufferedImage.getHeight();
                            IOUtils.closeQuietly((InputStream)inputStream);
                            inputStream = ImageUtils.base64DataToInputStream(img.getBase64Data());
                            try {
                                XSSFClientAnchor anchor = (XSSFClientAnchor)creationHelper.createClientAnchor();
                                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                                int pictureFormat = this.buildImageFormat(img);
                                int pictureIndex = wb.addPicture(bytes, pictureFormat);
                                anchor.setCol1(i);
                                anchor.setCol2(i + colSpan);
                                anchor.setRow1(rowNumber);
                                anchor.setRow2(rowNumber + rowSpan);
                                anchor.setDx1(0);
                                anchor.setDx2(width * 9525);
                                anchor.setDy1(0);
                                anchor.setDy2(height * 9525);
                                drawing.createPicture((ClientAnchor)anchor, pictureIndex);
                                continue;
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)inputStream);
                            }
                        }
                        if (!(obj instanceof Date)) continue;
                        cell.setCellValue((Date)obj);
                    }
                    row.setHeight((short)UnitUtils.pointToTwip(r.getRealHeight()));
                    ++rowNumber;
                }
                sheet.setRowBreak(rowNumber - 1);
            }
            wb.write(outputStream);
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Sheet createSheet(HSSFWorkbook wb, Paper paper, String name) {
        HSSFSheet sheet = null;
        sheet = name == null ? wb.createSheet() : wb.createSheet(name);
        PaperType paperType = paper.getPaperType();
        HSSFPrintSetup printSetup = (HSSFPrintSetup)sheet.getPrintSetup();
        Orientation orientation = paper.getOrientation();
        if (orientation.equals(Orientation.landscape)) {
            printSetup.setLandscape(true);
        }
        this.setupPaper(paperType, printSetup);
        int leftMargin = paper.getLeftMargin();
        int rightMargin = paper.getRightMargin();
        int topMargin = paper.getTopMargin();
        int bottomMargin = paper.getBottomMargin();
        sheet.setMargin((short)0, (double)UnitUtils.pointToInche(leftMargin));
        sheet.setMargin((short)1, (double)UnitUtils.pointToInche(rightMargin));
        sheet.setMargin((short)2, (double)UnitUtils.pointToInche(topMargin));
        sheet.setMargin((short)3, (double)UnitUtils.pointToInche(bottomMargin));
        return sheet;
    }

    private int buildImageFormat(Image img) {
        int type = 6;
        String path = img.getPath();
        if (path == null) {
            return type;
        }
        if ((path = path.toLowerCase()).endsWith("jpg") || path.endsWith("jpeg")) {
            type = 5;
        }
        return type;
    }

    private boolean setupPaper(PaperType paperType, HSSFPrintSetup printSetup) {
        boolean setup = false;
        switch (paperType) {
            case A0: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A1: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A2: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A3: {
                printSetup.setPaperSize((short)8);
                setup = true;
                break;
            }
            case A4: {
                printSetup.setPaperSize((short)53);
                setup = true;
                break;
            }
            case A5: {
                printSetup.setPaperSize((short)11);
                setup = true;
                break;
            }
            case A6: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A7: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A8: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A9: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case A10: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B0: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B1: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B2: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B3: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B4: {
                printSetup.setPaperSize((short)12);
                setup = true;
                break;
            }
            case B5: {
                printSetup.setPaperSize((short)13);
                setup = true;
                break;
            }
            case B6: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B7: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B8: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B9: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case B10: {
                printSetup.setPaperSize((short)53);
                break;
            }
            case CUSTOM: {
                printSetup.setPaperSize((short)53);
            }
        }
        return setup;
    }
}

