/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.builder.down;

import com.bstek.ureport.Range;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.parser.BuildUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LeftParentCellCreator {
    public List<Range> buildParentCells(CellDefinition cell) {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        Range childRange = this.buildChildrenCellRange(cell);
        ArrayList<CellDefinition> parentCells = new ArrayList<CellDefinition>();
        this.collectParentCells(cell, parentCells);
        this.buildParents(cell, parentCells, childRange, rangeList);
        return rangeList;
    }

    private void collectParentCells(CellDefinition cell, List<CellDefinition> parentCells) {
        CellDefinition leftParentCell = cell.getLeftParentCell();
        if (leftParentCell == null) {
            return;
        }
        parentCells.add(leftParentCell);
        this.collectParentCells(leftParentCell, parentCells);
    }

    private void buildParents(CellDefinition mainCell, List<CellDefinition> parentCells, Range childRange, List<Range> rangeList) {
        int rowNumberStart = mainCell.getRowNumber();
        int rowNumberEnd = BuildUtils.buildRowNumberEnd(mainCell, rowNumberStart);
        rangeList.add(new Range(rowNumberStart, rowNumberEnd));
        int start = childRange.getStart();
        int end = childRange.getEnd();
        Map<String, BlankCellInfo> newBlankCellsMap = mainCell.getNewBlankCellsMap();
        boolean increase = true;
        for (CellDefinition parentCell : parentCells) {
            String parentCellName = parentCell.getName();
            int parentRowNumberStart = parentCell.getRowNumber();
            int parentRowNumberEnd = BuildUtils.buildRowNumberEnd(parentCell, parentRowNumberStart);
            int offset = parentRowNumberStart - rowNumberStart;
            int parentRowSpan = parentCell.getRowSpan();
            boolean isOut = this.assertOut(parentCell, mainCell, childRange);
            if (isOut) {
                increase = false;
                boolean doBlank = this.assertDoBlank(parentCell.getLeftParentCell(), parentCell, mainCell, childRange);
                if (!doBlank) continue;
                newBlankCellsMap.put(parentCellName, new BlankCellInfo(offset, parentRowSpan, true));
                rangeList.add(new Range(parentRowNumberStart, parentRowNumberEnd));
                continue;
            }
            if (start != -1 && start < parentRowNumberStart || end > parentRowNumberEnd) {
                newBlankCellsMap.put(parentCellName, new BlankCellInfo(offset, parentRowSpan, true));
                rangeList.add(new Range(parentRowNumberStart, parentRowNumberEnd));
                increase = false;
                continue;
            }
            if (increase) {
                mainCell.getIncreaseSpanCellNames().add(parentCellName);
                continue;
            }
            newBlankCellsMap.put(parentCellName, new BlankCellInfo(offset, parentRowSpan, true));
            rangeList.add(new Range(parentRowNumberStart, parentRowNumberEnd));
        }
    }

    private boolean assertDoBlank(CellDefinition nextParentCell, CellDefinition parentCell, CellDefinition mainCell, Range childRange) {
        if (nextParentCell == null) {
            return false;
        }
        boolean isOut = this.assertOut(nextParentCell, mainCell, childRange);
        if (isOut) {
            return this.assertDoBlank(nextParentCell.getLeftParentCell(), parentCell, mainCell, childRange);
        }
        int start = parentCell.getRowNumber();
        int end = BuildUtils.buildRowNumberEnd(parentCell, start);
        int nextStart = nextParentCell.getRowNumber();
        if (nextStart <= end) {
            return true;
        }
        return this.assertDoBlank(nextParentCell.getLeftParentCell(), parentCell, mainCell, childRange);
    }

    private boolean assertOut(CellDefinition parentCell, CellDefinition mainCell, Range childRange) {
        int start = parentCell.getRowNumber();
        int end = BuildUtils.buildRowNumberEnd(parentCell, start);
        int rangeStart = childRange.getStart();
        int rangeEnd = childRange.getEnd();
        if (rangeStart != -1 && (start >= rangeStart && start <= rangeEnd || end >= rangeStart && end <= rangeEnd)) {
            return false;
        }
        int rowStart = mainCell.getRowNumber();
        int rowEnd = BuildUtils.buildRowNumberEnd(mainCell, rowStart);
        return !(start >= rowStart && start <= rowEnd || end >= rowStart && end <= rowEnd) && (start > rowStart || end < rowEnd);
    }

    private Range buildChildrenCellRange(CellDefinition mainCell) {
        Range range = new Range();
        List<CellDefinition> childrenCells = mainCell.getRowChildrenCells();
        for (CellDefinition childCell : childrenCells) {
            int childRowNumberStart = childCell.getRowNumber();
            int childRowSpan = childCell.getRowSpan();
            childRowSpan = childRowSpan > 0 ? childRowSpan - 1 : childRowSpan;
            int childRowNumberEnd = childRowNumberStart + childRowSpan;
            if (range.getStart() == -1 || childRowNumberStart < range.getStart()) {
                range.setStart(childRowNumberStart);
            }
            if (childRowNumberEnd <= range.getEnd()) continue;
            range.setEnd(childRowNumberEnd);
        }
        return range;
    }
}

