/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.builder.down;

import com.bstek.ureport.Range;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.export.builder.down.LeftParentCellCreator;
import com.bstek.ureport.parser.BuildUtils;
import java.util.List;
import java.util.Map;

public class DownCellbuilder {
    private LeftParentCellCreator leftParentCellCreator = new LeftParentCellCreator();

    public void buildParentCell(CellDefinition cell, List<CellDefinition> cells) {
        List<Range> rangeList = this.leftParentCellCreator.buildParentCells(cell);
        Range childRange = this.buildChildrenCells(cell, rangeList);
        this.buildChildrenBlankCells(cell, cells, childRange);
        Range rowRange = this.buildRowRange(rangeList);
        this.buildRowsBlankCells(cell, cells, rowRange);
        int start = rowRange.getStart();
        int end = rowRange.getEnd();
        int rowNumberStart = cell.getRowNumber();
        int rowNumberEnd = cell.getRowNumber();
        int rowSpan = cell.getRowSpan();
        if (rowSpan > 0) {
            rowNumberEnd += rowSpan - 1;
        }
        int rangeStart = 0;
        int rangeEnd = 0;
        if (start != -1) {
            rangeStart = start - rowNumberStart;
        }
        rangeEnd = end > rowNumberStart && end > rowNumberEnd ? end - rowNumberStart : rowNumberEnd - rowNumberStart;
        Range duplicateRange = new Range(rangeStart, rangeEnd);
        cell.setDuplicateRange(duplicateRange);
    }

    private void buildRowsBlankCells(CellDefinition cell, List<CellDefinition> cells, Range range) {
        Map<String, BlankCellInfo> blankCellNamesMap = cell.getNewBlankCellsMap();
        int start = range.getStart();
        int end = range.getEnd();
        int nextEnd = 0;
        for (int i = start; i <= end; ++i) {
            for (CellDefinition cellDef : cells) {
                int endRowNumber;
                String name = cellDef.getName();
                if (this.cellPrcessed(cell, name)) continue;
                int rowNumber = cellDef.getRowNumber();
                if (rowNumber == i) {
                    int offset = rowNumber - cell.getRowNumber();
                    blankCellNamesMap.put(name, new BlankCellInfo(offset, cellDef.getRowSpan(), false));
                    continue;
                }
                if (rowNumber >= i || (endRowNumber = BuildUtils.buildRowNumberEnd(cellDef, rowNumber)) < i) continue;
                int offset = rowNumber - cell.getRowNumber();
                blankCellNamesMap.put(name, new BlankCellInfo(offset, cellDef.getRowSpan(), false));
                if (i <= end || i <= nextEnd) continue;
                nextEnd = i;
            }
        }
        if (nextEnd > end) {
            this.buildRowsBlankCells(cell, cells, new Range(end, nextEnd));
        }
    }

    private Range buildRowRange(List<Range> rangeList) {
        Range rowRange = new Range();
        for (Range range : rangeList) {
            for (int i = range.getStart(); i <= range.getEnd(); ++i) {
                if (rowRange.getStart() == -1 || i < rowRange.getStart()) {
                    rowRange.setStart(i);
                }
                if (rowRange.getEnd() >= i) continue;
                rowRange.setEnd(i);
            }
        }
        return rowRange;
    }

    private Range buildChildrenCells(CellDefinition cell, List<Range> rangeList) {
        Range range = new Range();
        List<CellDefinition> rowChildrenCells = cell.getRowChildrenCells();
        for (CellDefinition childCell : rowChildrenCells) {
            cell.getNewCellNames().add(childCell.getName());
            int rowNumber = childCell.getRowNumber();
            int endRowNumber = BuildUtils.buildRowNumberEnd(childCell, rowNumber);
            rangeList.add(new Range(rowNumber, endRowNumber));
            if (endRowNumber > range.getEnd()) {
                range.setEnd(endRowNumber);
            }
            if (range.getStart() != -1 && rowNumber >= range.getStart()) continue;
            range.setStart(rowNumber);
        }
        return range;
    }

    private void buildChildrenBlankCells(CellDefinition cell, List<CellDefinition> cells, Range childRange) {
        int startRowNumber = cell.getRowNumber();
        int endRowNumber = BuildUtils.buildRowNumberEnd(cell, startRowNumber);
        int start = childRange.getStart();
        int end = childRange.getEnd();
        if (start != -1 && start < startRowNumber) {
            startRowNumber = start;
        }
        if (end > endRowNumber) {
            endRowNumber = end;
        }
        Map<String, BlankCellInfo> blankCellNamesMap = cell.getNewBlankCellsMap();
        for (int i = startRowNumber; i <= endRowNumber; ++i) {
            for (CellDefinition c : cells) {
                String name;
                boolean contain;
                if (c.getRowNumber() != i || c.equals(cell) || (contain = this.cellPrcessed(cell, name = c.getName()))) continue;
                int offset = c.getRowNumber() - cell.getRowNumber();
                blankCellNamesMap.put(name, new BlankCellInfo(offset, c.getRowSpan(), false));
            }
        }
    }

    private boolean cellPrcessed(CellDefinition cell, String name) {
        List<String> newCellNames = cell.getNewCellNames();
        List<String> increaseCellNames = cell.getIncreaseSpanCellNames();
        Map<String, BlankCellInfo> blankCellNamesMap = cell.getNewBlankCellsMap();
        boolean contain = false;
        if (cell.getName().equals(name)) {
            contain = true;
        }
        if (newCellNames.contains(name)) {
            contain = true;
        }
        if (increaseCellNames.contains(name)) {
            contain = true;
        }
        if (blankCellNamesMap.containsKey(name)) {
            contain = true;
        }
        return contain;
    }
}

