/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export;

import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.export.FullPageData;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.model.Report;
import java.util.ArrayList;
import java.util.List;

public class PageBuilder {
    public static FullPageData buildFullPageData(Report report) {
        int pageSize;
        List<Page> pages = report.getPages();
        int totalPages = pageSize = pages.size();
        Paper paper = report.getPaper();
        ArrayList<List<Page>> list = new ArrayList<List<Page>>();
        if (paper.isColumnEnabled()) {
            int columnCount = paper.getColumnCount();
            int mode = (totalPages /= columnCount) % columnCount;
            if (mode > 0) {
                ++totalPages;
            }
            for (int i = 0; i < pageSize; ++i) {
                ArrayList<Page> columnPages = new ArrayList<Page>();
                int end = i + columnCount;
                int j = i;
                while (j < end && j < pageSize) {
                    columnPages.add(pages.get(j));
                    i = j++;
                }
                list.add(columnPages);
            }
        }
        return new FullPageData(totalPages, paper.getColumnMargin(), list);
    }

    public static SinglePageData buildSinglePageData(int pageIndex, Report report) {
        int pageSize;
        List<Page> pages = report.getPages();
        int totalPages = pageSize = pages.size();
        Paper paper = report.getPaper();
        ArrayList<Page> columnPages = new ArrayList<Page>();
        if (paper.isColumnEnabled()) {
            int columnCount = paper.getColumnCount();
            totalPages = pageSize / columnCount;
            int mode = pageSize % columnCount;
            if (mode > 0) {
                ++totalPages;
            }
            int pageStart = (pageIndex - 1) * columnCount;
            int pageEnd = pageStart + columnCount;
            if (pageStart + 1 > pageSize) {
                pageStart = pageSize - 1;
            }
            if (pageEnd <= pageStart) {
                pageEnd = pageStart + 1;
            }
            for (int i = pageStart; i < pageEnd && i < pageSize; ++i) {
                columnPages.add(pages.get(i));
            }
        } else {
            if (pageIndex > pageSize) {
                pageIndex = pageSize;
            }
            columnPages.add(pages.get(pageIndex - 1));
        }
        return new SinglePageData(totalPages, pageIndex, paper.getColumnMargin(), columnPages);
    }

    public static void main(String[] args) {
        int columnCount = 3;
        int totalPages = 30;
        int total = totalPages / columnCount;
        int mode = totalPages % columnCount;
        if (mode > 0) {
            ++total;
        }
        System.out.println(total);
    }
}

