/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.paging;

import com.bstek.ureport.build.paging.BasePagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.build.paging.Pagination;
import com.bstek.ureport.definition.Band;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.List;

public class FixRowsPagination
extends BasePagination
implements Pagination {
    @Override
    public List<Page> doPaging(Report report) {
        Paper paper = report.getPaper();
        List<Row> rows = report.getRows();
        List<Row> headerRows = report.getHeaderRepeatRows();
        List<Row> footerRows = report.getFooterRepeatRows();
        List<Row> titleRows = report.getTitleRows();
        List<Row> summaryRows = report.getSummaryRows();
        int fixRows = paper.getFixRows() - headerRows.size() - footerRows.size();
        if (fixRows < 0) {
            fixRows = 1;
        }
        ArrayList<Row> pageRepeatHeaders = new ArrayList<Row>();
        ArrayList<Row> pageRepeatFooters = new ArrayList<Row>();
        pageRepeatHeaders.addAll(headerRows);
        pageRepeatFooters.addAll(footerRows);
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<Row> pageRows = new ArrayList<Row>();
        int pageIndex = 1;
        for (Row row : rows) {
            int height = row.getRealHeight();
            if (height == 0) continue;
            Band band = row.getBand();
            if (band != null) {
                int j;
                String rowKey = row.getRowKey();
                int index = -1;
                if (band.equals((Object)Band.headerrepeat)) {
                    for (j = 0; j < pageRepeatHeaders.size(); ++j) {
                        Row headerRow = (Row)pageRepeatHeaders.get(j);
                        if (!headerRow.getRowKey().equals(rowKey)) continue;
                        index = j;
                        break;
                    }
                    pageRepeatHeaders.remove(index);
                    pageRepeatHeaders.add(index, row);
                    continue;
                }
                if (!band.equals((Object)Band.footerrepeat)) continue;
                for (j = 0; j < pageRepeatFooters.size(); ++j) {
                    Row footerRow = (Row)pageRepeatFooters.get(j);
                    if (!footerRow.getRowKey().equals(rowKey)) continue;
                    index = j;
                    break;
                }
                pageRepeatFooters.remove(index);
                pageRepeatFooters.add(index, row);
                continue;
            }
            pageRows.add(row);
            row.setPageIndex(pageIndex);
            if (pageRows.size() < fixRows) continue;
            Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
            ++pageIndex;
            pages.add(newPage);
            pageRows = new ArrayList();
        }
        if (pageRows.size() > 0) {
            Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
            ++pageIndex;
            pages.add(newPage);
        }
        report.getContext().setTotalPages(pages.size());
        this.buildPageHeaderFooter(pages, report);
        this.buildSummaryRows(summaryRows, pages);
        return pages;
    }
}

