/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.compute;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.compute.ValueCompute;
import com.bstek.ureport.definition.value.ImageValue;
import com.bstek.ureport.definition.value.Source;
import com.bstek.ureport.definition.value.ValueType;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.image.ImageType;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Image;
import com.bstek.ureport.utils.ImageUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ImageValueCompute
implements ValueCompute {
    @Override
    public List<BindData> compute(Cell cell, Context context) {
        ImageValue value = (ImageValue)cell.getValue();
        int width = value.getWidth();
        int height = value.getHeight();
        Source source = value.getSource();
        ArrayList<BindData> list = new ArrayList<BindData>();
        if (source.equals((Object)Source.text)) {
            String base64Data = ImageUtils.getImageBase64Data(ImageType.image, value.getValue(), width, height);
            list.add(new BindData(new Image(base64Data, value.getValue(), -1, -1)));
        } else {
            Expression expression = value.getExpression();
            ExpressionData<?> data = expression.execute(cell, cell, context);
            Object obj = data.getData();
            if (obj instanceof List) {
                List listData = (List)obj;
                for (Object o : listData) {
                    if (o == null) continue;
                    String path = null;
                    if (o instanceof BindData) {
                        BindData bindData = (BindData)o;
                        Object valueData = bindData.getValue();
                        if (valueData != null) {
                            path = valueData.toString();
                        }
                    } else {
                        path = o.toString();
                    }
                    if (StringUtils.isBlank((CharSequence)path)) continue;
                    String base64Data = ImageUtils.getImageBase64Data(ImageType.image, path, width, height);
                    list.add(new BindData(new Image(base64Data, path, -1, -1)));
                }
            } else if (obj instanceof BindData) {
                BindData bindData = (BindData)obj;
                String path = null;
                Object valueData = bindData.getValue();
                if (valueData != null) {
                    path = valueData.toString();
                }
                if (StringUtils.isNotBlank(path)) {
                    String base64Data = ImageUtils.getImageBase64Data(ImageType.image, path, width, height);
                    list.add(new BindData(new Image(base64Data, path, -1, -1)));
                }
            } else if (obj instanceof String) {
                String text = obj.toString();
                if (text.startsWith("\"") && text.endsWith("\"")) {
                    text = text.substring(1, text.length() - 1);
                }
                String base64Data = ImageUtils.getImageBase64Data(ImageType.image, text, width, height);
                list.add(new BindData(new Image(base64Data, text, -1, -1)));
            } else if (obj != null && StringUtils.isNotBlank((CharSequence)obj.toString())) {
                String base64Data = ImageUtils.getImageBase64Data(ImageType.image, obj.toString(), width, height);
                list.add(new BindData(new Image(base64Data, obj.toString(), -1, -1)));
            }
        }
        return list;
    }

    @Override
    public ValueType type() {
        return ValueType.image;
    }
}

