/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.DuplicateType;
import com.bstek.ureport.build.cell.right.RightDuplicate;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;

public class CellRightDuplicator {
    private Cell cell;
    private int cellColNumber;
    private DuplicateType duplicateType;
    private BlankCellInfo blankCellInfo;
    private boolean nonChild = false;

    public CellRightDuplicator(Cell cell, DuplicateType duplicateType, int cellColNumber) {
        this.cell = cell;
        this.duplicateType = duplicateType;
        this.cellColNumber = cellColNumber;
    }

    public CellRightDuplicator(Cell cell, DuplicateType duplicateType, BlankCellInfo blankCellInfo, int cellColNumber) {
        this.cell = cell;
        this.duplicateType = duplicateType;
        this.blankCellInfo = blankCellInfo;
        this.cellColNumber = cellColNumber > 0 ? cellColNumber : cell.getColumn().getColumnNumber();
    }

    public Cell duplicate(RightDuplicate rightDuplicate, Cell newMainCell) {
        switch (this.duplicateType) {
            case Blank: {
                this.processBlankCell(rightDuplicate, newMainCell);
                break;
            }
            case Self: {
                this.processSelfBlankCell(rightDuplicate);
                break;
            }
            case IncreseSpan: {
                this.processIncreaseSpanCell(rightDuplicate);
                break;
            }
            case Duplicate: {
                throw new ReportComputeException("Invalid duplicator.");
            }
        }
        return null;
    }

    private void processSelfBlankCell(RightDuplicate rightDuplicate) {
        Cell topParentCell;
        Cell newBlankCell = this.cell.newCell();
        newBlankCell.setValue(new SimpleValue(""));
        Column newCol = rightDuplicate.newColumn(newBlankCell.getColumn(), this.cellColNumber);
        newCol.getCells().add(newBlankCell);
        newBlankCell.getRow().getCells().add(newBlankCell);
        newBlankCell.setColumn(newCol);
        Cell leftParentCell = newBlankCell.getLeftParentCell();
        if (leftParentCell != null) {
            leftParentCell.addRowChild(newBlankCell);
        }
        if ((topParentCell = newBlankCell.getTopParentCell()) != null) {
            topParentCell.addColumnChild(newBlankCell);
        }
        Context context = rightDuplicate.getContext();
        context.addBlankCell(newBlankCell);
    }

    public Cell duplicateChildrenCell(RightDuplicate rightDuplicate, Cell topParent, Cell originalCell, boolean parentNonChild) {
        Cell topParentCell;
        Cell leftParentCell;
        Cell newCell = this.cell.newCell();
        Column newCol = rightDuplicate.newColumn(newCell.getColumn(), this.cellColNumber);
        newCol.getCells().add(newCell);
        newCell.getRow().getCells().add(newCell);
        newCell.setColumn(newCol);
        if (newCell.getTopParentCell() == originalCell) {
            newCell.setTopParentCell(topParent);
            if (parentNonChild) {
                this.nonChild = true;
            }
        } else {
            this.nonChild = true;
        }
        if ((leftParentCell = newCell.getLeftParentCell()) != null) {
            leftParentCell.addRowChild(newCell);
        }
        if ((topParentCell = newCell.getTopParentCell()) != null) {
            topParentCell.addColumnChild(newCell);
        }
        Context context = rightDuplicate.getContext();
        Value value = newCell.getValue();
        if (value instanceof SimpleValue) {
            newCell.setData(value.getValue());
            newCell.setProcessed(true);
            context.addReportCell(newCell);
        } else if (this.nonChild) {
            newCell.setValue(new SimpleValue(""));
            context.addBlankCell(newCell);
        } else {
            context.addCell(newCell);
        }
        return newCell;
    }

    private void processIncreaseSpanCell(RightDuplicate rightDuplicate) {
        int colSpan = this.cell.getColSpan();
        if ((colSpan += rightDuplicate.getColSize()) == 1) {
            ++colSpan;
        }
        this.cell.setColSpan(colSpan);
    }

    private void processBlankCell(RightDuplicate rightDuplicate, Cell newMainCell) {
        Context context = rightDuplicate.getContext();
        Cell newBlankCell = this.cell.newColumnBlankCell(context, this.blankCellInfo, rightDuplicate.getMainCell());
        if (this.blankCellInfo.isParent() && newMainCell.getTopParentCell() == this.cell) {
            newMainCell.setTopParentCell(newBlankCell);
        }
        Column col = rightDuplicate.newColumn(newBlankCell.getColumn(), this.cellColNumber);
        col.getCells().add(newBlankCell);
        newBlankCell.getRow().getCells().add(newBlankCell);
        newBlankCell.setColumn(col);
        context.addReportCell(newBlankCell);
    }

    public DuplicateType getDuplicateType() {
        return this.duplicateType;
    }

    public Cell getCell() {
        return this.cell;
    }

    public boolean isNonChild() {
        return this.nonChild;
    }

    public void setNonChild(boolean nonChild) {
        this.nonChild = nonChild;
    }
}

