/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.NoHttpServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinList {
    private static Logger logger = LoggerFactory.getLogger(RoundRobinList.class);
    private final List<HttpAddress> elements;
    private Iterator<HttpAddress> iterator;
    private Lock lock = new ReentrantLock();

    public RoundRobinList(List<HttpAddress> elements) {
        this.elements = elements;
        this.iterator = this.elements.iterator();
    }

    public void addAddresses(List<HttpAddress> address) {
        try {
            this.lock.lock();
            this.elements.addAll(address);
            this.iterator = this.elements.iterator();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpAddress get() {
        try {
            this.lock.lock();
            HttpAddress address2 = null;
            HttpAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                HttpAddress httpAddress = temp;
                return httpAddress;
            }
            for (HttpAddress address2 : this.elements) {
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp == null) {
                String message = "All Http Server " + this.elements.toString() + " can't been connected.";
                throw new NoHttpServerException(message);
            }
            HttpAddress httpAddress = temp;
            return httpAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpAddress getFromRouting() {
        try {
            this.lock.lock();
            HttpAddress address2 = null;
            HttpAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                HttpAddress httpAddress = temp;
                return httpAddress;
            }
            for (HttpAddress address2 : this.elements) {
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp == null && logger.isDebugEnabled()) {
                String message = "All Http Server " + this.elements.toString() + " can't been connected.";
                logger.debug(message);
            }
            HttpAddress httpAddress = temp;
            return httpAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        try {
            this.lock.lock();
            int n = this.elements.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

