/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck
implements Runnable {
    private List<HttpAddress> esAddresses;
    private static Logger logger = LoggerFactory.getLogger(HealthCheck.class);
    private long checkInterval = 5000L;
    private List<HCRunable> checkThreads;
    private Map<String, String> headers;
    private String poolName;

    public HealthCheck(String poolName, List<HttpAddress> esAddresses, long checkInterval, Map<String, String> headers) {
        this.esAddresses = esAddresses;
        this.checkInterval = checkInterval;
        this.headers = headers;
        this.poolName = poolName;
    }

    public void stopCheck() {
        HCRunable t = null;
        for (int i = 0; i < this.checkThreads.size(); ++i) {
            t = this.checkThreads.get(i);
            t.stopRun();
        }
    }

    public void checkNewAddresses(List<HttpAddress> addresses) {
        HCRunable t = null;
        for (int i = 0; i < addresses.size(); ++i) {
            HttpAddress address = addresses.get(i);
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    @Override
    public void run() {
        Iterator<HttpAddress> iterable = this.esAddresses.iterator();
        this.checkThreads = new ArrayList<HCRunable>();
        HCRunable t = null;
        HttpAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
        BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                HealthCheck.this.stopCheck();
            }
        });
    }

    public void addNewAddress(List<HttpAddress> addresses) {
        Iterator<HttpAddress> iterable = addresses.iterator();
        HCRunable t = null;
        HttpAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    class HCRunable
    extends Thread {
        HttpAddress address;
        boolean stop;

        public HCRunable(HttpAddress address) {
            super("Http pool[" + HealthCheck.this.poolName + "] server[" + address.toString() + "] health check");
            this.stop = false;
            address.setHealthCheck(this);
            this.address = address;
        }

        public void stopRun() {
            this.stop = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                if (this.address.failedCheck()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Check downed Http pool[" + HealthCheck.this.poolName + "] server[" + this.address.toString() + "] status.");
                        }
                        HttpRequestUtil.httpGet("HealthCheck_CommonHttpPool", this.address.getHealthPath(), HealthCheck.this.headers, new ResponseHandler<Void>(){

                            public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                                int status = response.getStatusLine().getStatusCode();
                                if (status >= 200 && status < 300) {
                                    if (logger.isInfoEnabled()) {
                                        logger.info("Downed Http pool[" + HealthCheck.this.poolName + "] server[" + HCRunable.this.address.toString() + "] recovered to normal server.");
                                    }
                                    HCRunable.this.address.onlySetStatus(0);
                                } else {
                                    HCRunable.this.address.onlySetStatus(1);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Down Http  pool[" + HealthCheck.this.poolName + "] Server health check use [" + this.address.getHealthPath() + "] failed:" + " Http server[" + this.address.toString() + "] is down.");
                        }
                        this.address.onlySetStatus(1);
                    }
                    if (this.stop) break;
                    try {
                        HCRunable.sleep(HealthCheck.this.checkInterval);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                try {
                    HCRunable e = this;
                    synchronized (e) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

