/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.BeanNameAware;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.InitializingBean;
import org.frameworkset.spi.SPIException;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.MapGetProperties;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.remote.http.ConfigHttpRuntimeException;
import org.frameworkset.spi.remote.http.ConnectionResetHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.CustomHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.DefaultHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.HttpConnectionKeepAliveStrategy;
import org.frameworkset.spi.remote.http.HttpRequestRetryHandlerHelper;
import org.frameworkset.spi.remote.http.proxy.ExceptionWare;
import org.frameworkset.spi.remote.http.proxy.HttpHostDiscover;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration
implements InitializingBean,
BeanNameAware {
    public static final ContentType TEXT_PLAIN_UTF_8 = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
    public static final ContentType TEXT_HTML_UTF_8 = ContentType.create((String)"text/html", (Charset)Consts.UTF_8);
    private static final int TIMEOUT_CONNECTION = 20000;
    private static final int TIMEOUT_SOCKET = 20000;
    private static final int RETRY_TIME = 3;
    private static final DefaultHttpRequestRetryHandler defaultHttpRequestRetryHandler = new ConnectionResetHttpRequestRetryHandler();
    private static Logger logger = LoggerFactory.getLogger(ClientConfiguration.class);
    private static RequestConfig defaultRequestConfig;
    private static HttpClient defaultHttpclient;
    private static Map<String, ClientConfiguration> clientConfigs;
    private static BaseApplicationContext context;
    private static boolean emptyContext;
    private static ClientConfiguration defaultClientConfiguration;
    private transient CloseableHttpClient httpclient;
    private transient RequestConfig requestConfig;
    private int timeoutConnection = 20000;
    private int timeoutSocket = 20000;
    private int connectionRequestTimeout = 20000;
    private int retryTime = 3;
    private int maxLineLength = 2000;
    private int maxHeaderCount = 200;
    private int maxTotal = 200;
    private int defaultMaxPerRoute = 10;
    private long retryInterval = -1L;
    private Boolean soKeepAlive = false;
    private Boolean soReuseAddress = false;
    private String hostnameVerifierString;
    private GetProperties contextProperties;
    private HttpServiceHosts httpServiceHosts;
    private int validateAfterInactivity = 2000;
    private boolean staleConnectionCheckEnabled = false;
    private String customHttpRequestRetryHandler;
    private int timeToLive = 3600000;
    private String keystore;
    private String keyPassword;
    private String supportedProtocols;
    private String[] _supportedProtocols;
    private transient HostnameVerifier hostnameVerifier;
    private String[] defaultSupportedProtocols = new String[]{"TLSv1"};
    private long keepAlive = 3600000L;
    private String beanName;

    public HttpServiceHosts getHttpServiceHosts() {
        return this.httpServiceHosts;
    }

    public void setHttpServiceHosts(HttpServiceHosts httpServiceHosts) {
        this.httpServiceHosts = httpServiceHosts;
    }

    public String getBeanName() {
        return this.beanName;
    }

    private static void loadClientConfiguration() {
        if (context == null) {
            context = DefaultApplicationContext.getApplicationContext((String)"conf/httpclient.xml");
            emptyContext = context.isEmptyContext();
        }
    }

    public static RequestConfig getDefaultRequestConfig() {
        return defaultRequestConfig;
    }

    public static HttpClient getDefaultHttpclient() {
        ClientConfiguration.loadClientConfiguration();
        return ClientConfiguration.getDefaultClientConfiguration().getHttpclient();
    }

    public static ClientConfiguration getDefaultClientConfiguration() {
        ClientConfiguration.loadClientConfiguration();
        if (defaultClientConfiguration != null) {
            return defaultClientConfiguration;
        }
        if (defaultClientConfiguration == null) {
            try {
                defaultClientConfiguration = ClientConfiguration.makeDefualtClientConfiguration("default");
            }
            catch (Exception e) {
                throw new ConfigHttpRuntimeException("Get DefaultClientConfiguration[default] failed:", e);
            }
        }
        return defaultClientConfiguration;
    }

    private static ClientConfiguration _getDefaultClientConfiguration(GetProperties context) {
        if (defaultClientConfiguration != null) {
            return defaultClientConfiguration;
        }
        try {
            defaultClientConfiguration = ClientConfiguration.makeDefualtClientConfiguration("default", context);
        }
        catch (Exception e) {
            throw new ConfigHttpRuntimeException("Get DefaultClientConfiguration[default] failed:", e);
        }
        return defaultClientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientConfiguration makeDefualtClientConfiguration(String name) throws Exception {
        ClientConfiguration clientConfiguration = clientConfigs.get(name);
        if (clientConfiguration != null) {
            return clientConfiguration;
        }
        Class<ClientConfiguration> clazz = ClientConfiguration.class;
        synchronized (ClientConfiguration.class) {
            block13: {
                clientConfiguration = clientConfigs.get(name);
                if (clientConfiguration != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return clientConfiguration;
                }
                if (!emptyContext) {
                    try {
                        clientConfiguration = (ClientConfiguration)context.getTBeanObject(name, ClientConfiguration.class);
                    }
                    catch (SPIException e) {
                        if (!logger.isWarnEnabled() || name.startsWith("HealthCheck_")) break block13;
                        logger.warn("Make ClientConfiguration [" + name + "] failed,an internal http pool will been constructed:" + e.getMessage());
                    }
                }
            }
            if (clientConfiguration == null) {
                if (!name.startsWith("HealthCheck_")) {
                    clientConfiguration = new ClientConfiguration();
                    clientConfiguration.setTimeoutConnection(50000);
                    clientConfiguration.setTimeoutSocket(50000);
                    clientConfiguration.setConnectionRequestTimeout(50000);
                    clientConfiguration.setRetryTime(-1);
                    clientConfiguration.setRetryInterval(-1L);
                    clientConfiguration.setMaxLineLength(Integer.MAX_VALUE);
                    clientConfiguration.setMaxHeaderCount(Integer.MAX_VALUE);
                    clientConfiguration.setMaxTotal(500);
                    clientConfiguration.setDefaultMaxPerRoute(100);
                    clientConfiguration.setStaleConnectionCheckEnabled(false);
                    clientConfiguration.setValidateAfterInactivity(2000);
                    clientConfiguration.setCustomHttpRequestRetryHandler(null);
                    clientConfiguration.setBeanName(name);
                    clientConfiguration.afterPropertiesSet();
                    clientConfigs.put(name, clientConfiguration);
                    if (logger.isInfoEnabled()) {
                        logger.info("Make http pool[{}] use default config completed!", (Object)name);
                    }
                } else {
                    clientConfiguration = new ClientConfiguration();
                    clientConfiguration.setTimeoutConnection(5000);
                    clientConfiguration.setTimeoutSocket(5000);
                    clientConfiguration.setConnectionRequestTimeout(5000);
                    clientConfiguration.setRetryTime(-1);
                    clientConfiguration.setRetryInterval(-1L);
                    clientConfiguration.setMaxLineLength(Integer.MAX_VALUE);
                    clientConfiguration.setMaxHeaderCount(Integer.MAX_VALUE);
                    clientConfiguration.setMaxTotal(500);
                    clientConfiguration.setDefaultMaxPerRoute(50);
                    clientConfiguration.setStaleConnectionCheckEnabled(false);
                    clientConfiguration.setValidateAfterInactivity(5000);
                    clientConfiguration.setCustomHttpRequestRetryHandler(null);
                    clientConfiguration.setBeanName(name);
                    clientConfiguration.afterPropertiesSet();
                    clientConfigs.put(name, clientConfiguration);
                    if (logger.isInfoEnabled()) {
                        logger.info("Make http pool[{}] use default config completed!", (Object)name);
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return clientConfiguration;
        }
    }

    private static long _getLongValue(String poolName, String propertyName, GetProperties context, long defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        long ret = Long.parseLong(_value);
        return ret;
    }

    private static boolean _getBooleanValue(String poolName, String propertyName, GetProperties context, boolean defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        boolean ret = Boolean.parseBoolean(_value);
        return ret;
    }

    private static int _getIntValue(String poolName, String propertyName, GetProperties context, int defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        int ret = Integer.parseInt(_value);
        return ret;
    }

    private static String _getStringValue(String poolName, String propertyName, GetProperties context, String defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return _value;
    }

    private static Object _getObjectValue(String poolName, String propertyName, GetProperties context, Object defaultValue) throws Exception {
        Object _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalObjectProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalObjectProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalObjectProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return _value;
    }

    private static HostnameVerifier _getHostnameVerifier(String hostnameVerifier) throws Exception {
        if (hostnameVerifier == null) {
            return null;
        }
        if (hostnameVerifier.equals("defualt")) {
            return SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }
        return SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
    }

    public static void startHttpPools(String configFile) {
        block10: {
            if (configFile == null || configFile.equals("")) {
                if (logger.isWarnEnabled()) {
                    StringBuilder message = new StringBuilder();
                    message.append("Ignore start HttpPools from configfile[").append(configFile).append("]: configFile path is empty!");
                    logger.warn(message.toString());
                }
                return;
            }
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            propertiesContainer.addConfigPropertiesFile(configFile);
            String poolNames = propertiesContainer.getProperty("http.poolNames");
            if (poolNames == null) {
                try {
                    ClientConfiguration.makeDefualtClientConfiguration("default", (GetProperties)propertiesContainer);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block10;
                    StringBuilder message = new StringBuilder();
                    message.append("Start HttpPools from configfile[").append(configFile).append("] failed:");
                    logger.error(message.toString(), (Throwable)e);
                }
            } else {
                String[] poolNames_;
                for (String poolName : poolNames_ = poolNames.split(",")) {
                    if ((poolName = poolName.trim()).equals("")) {
                        poolName = "default";
                    }
                    try {
                        ClientConfiguration.makeDefualtClientConfiguration(poolName, (GetProperties)propertiesContainer);
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) continue;
                        StringBuilder message = new StringBuilder();
                        message.append("Start HttpPools from configfile[").append(configFile).append("] failed:");
                        logger.error(message.toString(), (Throwable)e);
                    }
                }
            }
        }
    }

    public static void startHttpPools(Map<String, Object> configs) {
        block10: {
            if (configs == null || configs.size() == 0) {
                if (logger.isWarnEnabled()) {
                    StringBuilder message = new StringBuilder();
                    message.append("Ignore start HttpPools from configs: configs is null or empty!");
                    logger.warn(message.toString());
                }
                return;
            }
            MapGetProperties propertiesContainer = new MapGetProperties(configs);
            String poolNames = propertiesContainer.getExternalProperty("http.poolNames");
            if (poolNames == null) {
                try {
                    ClientConfiguration.makeDefualtClientConfiguration("default", (GetProperties)propertiesContainer);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block10;
                    StringBuilder message = new StringBuilder();
                    message.append("Start HttpPool[default] from configs failed:");
                    logger.error(message.toString(), (Throwable)e);
                }
            } else {
                String[] poolNames_;
                for (String poolName : poolNames_ = poolNames.split(",")) {
                    if ((poolName = poolName.trim()).equals("")) {
                        poolName = "default";
                    }
                    try {
                        ClientConfiguration.makeDefualtClientConfiguration(poolName, (GetProperties)propertiesContainer);
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) continue;
                        StringBuilder message = new StringBuilder();
                        message.append("Start HttpPool[").append(poolName).append("] from configs failed:");
                        logger.error(message.toString(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientConfiguration makeDefualtClientConfiguration(String name, GetProperties context) throws Exception {
        ClientConfiguration clientConfiguration = clientConfigs.get(name);
        if (clientConfiguration != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Ignore MakeDefualtClientConfiguration and return existed Http Pool[{}].", (Object)name);
            }
            return clientConfiguration;
        }
        Class<ClientConfiguration> clazz = ClientConfiguration.class;
        synchronized (ClientConfiguration.class) {
            HttpServiceHosts httpServiceHosts;
            StringBuilder log;
            block30: {
                block29: {
                    block28: {
                        Object exceptionWare;
                        clientConfiguration = clientConfigs.get(name);
                        if (clientConfiguration != null) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return clientConfiguration;
                        }
                        clientConfiguration = new ClientConfiguration();
                        clientConfiguration.setContextProperties(context);
                        log = new StringBuilder();
                        int timeoutConnection = ClientConfiguration._getIntValue(name, "http.timeoutConnection", context, 50000);
                        log.append("http.timeoutConnection=").append(timeoutConnection);
                        clientConfiguration.setTimeoutConnection(timeoutConnection);
                        int timeoutSocket = ClientConfiguration._getIntValue(name, "http.timeoutSocket", context, 50000);
                        log.append(",http.timeoutSocket=").append(timeoutSocket);
                        clientConfiguration.setTimeoutSocket(timeoutSocket);
                        int connectionRequestTimeout = ClientConfiguration._getIntValue(name, "http.connectionRequestTimeout", context, 50000);
                        log.append(",http.connectionRequestTimeout=").append(connectionRequestTimeout);
                        clientConfiguration.setConnectionRequestTimeout(connectionRequestTimeout);
                        int retryTime = ClientConfiguration._getIntValue(name, "http.retryTime", context, -1);
                        log.append(",http.retryTime=").append(retryTime);
                        clientConfiguration.setRetryTime(retryTime);
                        long retryInterval = ClientConfiguration._getLongValue(name, "http.retryInterval", context, -1L);
                        log.append(",http.retryInterval=").append(retryInterval);
                        clientConfiguration.setRetryInterval(retryInterval);
                        int maxLineLength = ClientConfiguration._getIntValue(name, "http.maxLineLength", context, -1);
                        log.append(",http.maxLineLength=").append(maxLineLength);
                        clientConfiguration.setMaxLineLength(maxLineLength);
                        int maxHeaderCount = ClientConfiguration._getIntValue(name, "http.maxHeaderCount", context, 500);
                        log.append(",http.maxHeaderCount=").append(maxHeaderCount);
                        clientConfiguration.setMaxHeaderCount(maxHeaderCount);
                        int maxTotal = ClientConfiguration._getIntValue(name, "http.maxTotal", context, 1000);
                        log.append(",http.maxTotal=").append(maxTotal);
                        clientConfiguration.setMaxTotal(maxTotal);
                        boolean soReuseAddress = ClientConfiguration._getBooleanValue(name, "http.soReuseAddress", context, false);
                        log.append(",http.soReuseAddress=").append(soReuseAddress);
                        clientConfiguration.setSoReuseAddress(soReuseAddress);
                        boolean soKeepAlive = ClientConfiguration._getBooleanValue(name, "http.soKeepAlive", context, false);
                        log.append(",http.soKeepAlive=").append(soKeepAlive);
                        clientConfiguration.setSoKeepAlive(soKeepAlive);
                        int timeToLive = ClientConfiguration._getIntValue(name, "http.timeToLive", context, 3600000);
                        log.append(",http.timeToLive=").append(timeToLive);
                        clientConfiguration.setTimeToLive(timeToLive);
                        int keepAlive = ClientConfiguration._getIntValue(name, "http.keepAlive", context, 3600000);
                        log.append(",http.keepAlive=").append(keepAlive);
                        clientConfiguration.setKeepAlive(keepAlive);
                        int defaultMaxPerRoute = ClientConfiguration._getIntValue(name, "http.defaultMaxPerRoute", context, 200);
                        log.append(",http.defaultMaxPerRoute=").append(defaultMaxPerRoute);
                        clientConfiguration.setDefaultMaxPerRoute(defaultMaxPerRoute);
                        int validateAfterInactivity = ClientConfiguration._getIntValue(name, "http.validateAfterInactivity", context, 2000);
                        log.append(",http.validateAfterInactivity=").append(validateAfterInactivity);
                        clientConfiguration.setValidateAfterInactivity(validateAfterInactivity);
                        boolean staleConnectionCheckEnabled = ClientConfiguration._getBooleanValue(name, "http.staleConnectionCheckEnabled", context, false);
                        log.append(",http.staleConnectionCheckEnabled=").append(staleConnectionCheckEnabled);
                        clientConfiguration.setStaleConnectionCheckEnabled(staleConnectionCheckEnabled);
                        String customHttpRequestRetryHandler = ClientConfiguration._getStringValue(name, "http.customHttpRequestRetryHandler", context, null);
                        log.append(",http.customHttpRequestRetryHandler=").append(customHttpRequestRetryHandler);
                        clientConfiguration.setCustomHttpRequestRetryHandler(customHttpRequestRetryHandler);
                        String keystore = ClientConfiguration._getStringValue(name, "http.keystore", context, null);
                        log.append(",http.keystore=").append(keystore);
                        clientConfiguration.setKeystore(keystore);
                        String keyPassword = ClientConfiguration._getStringValue(name, "http.keyPassword", context, null);
                        log.append(",http.keyPassword=").append(keyPassword);
                        clientConfiguration.setKeyPassword(keyPassword);
                        String hostnameVerifier = ClientConfiguration._getStringValue(name, "http.hostnameVerifier", context, null);
                        log.append(",http.hostnameVerifier=").append(hostnameVerifier);
                        clientConfiguration.setHostnameVerifierString(hostnameVerifier);
                        clientConfiguration.setHostnameVerifier(ClientConfiguration._getHostnameVerifier(hostnameVerifier));
                        clientConfiguration.setBeanName(name);
                        httpServiceHosts = new HttpServiceHosts();
                        httpServiceHosts.setClientConfiguration(clientConfiguration);
                        String authAccount = ClientConfiguration._getStringValue(name, "http.authAccount", context, null);
                        httpServiceHosts.setAuthAccount(authAccount);
                        String authPassword = ClientConfiguration._getStringValue(name, "http.authPassword", context, null);
                        httpServiceHosts.setAuthPassword(authPassword);
                        String routing = ClientConfiguration._getStringValue(name, "http.routing", context, null);
                        httpServiceHosts.setRouting(routing);
                        String health = ClientConfiguration._getStringValue(name, "http.health", context, null);
                        httpServiceHosts.setHealth(health);
                        Object discoverService = ClientConfiguration._getObjectValue(name, "http.discoverService", context, null);
                        if (discoverService != null) {
                            if (discoverService instanceof String) {
                                httpServiceHosts.setDiscoverService((String)discoverService);
                            } else if (discoverService instanceof HttpHostDiscover) {
                                httpServiceHosts.setHostDiscover((HttpHostDiscover)discoverService);
                            }
                        }
                        if ((exceptionWare = ClientConfiguration._getObjectValue(name, "http.exceptionWare", context, null)) != null) {
                            if (exceptionWare instanceof String) {
                                httpServiceHosts.setExceptionWare((String)exceptionWare);
                            } else if (exceptionWare instanceof ExceptionWare) {
                                httpServiceHosts.setExceptionWareBean((ExceptionWare)exceptionWare);
                            }
                        }
                        String hosts = ClientConfiguration._getStringValue(name, "http.hosts", context, null);
                        httpServiceHosts.setHosts(hosts);
                        String healthCheckInterval_ = ClientConfiguration._getStringValue(name, "http.healthCheckInterval", context, null);
                        if (healthCheckInterval_ == null) {
                            httpServiceHosts.setHealthCheckInterval(3000L);
                        } else {
                            try {
                                httpServiceHosts.setHealthCheckInterval(Long.parseLong(healthCheckInterval_));
                            }
                            catch (Exception e) {
                                if (!logger.isErrorEnabled()) break block28;
                                logger.error("Parse Long healthCheckInterval parameter failed:" + healthCheckInterval_, (Throwable)e);
                            }
                        }
                    }
                    String discoverServiceInterval_ = ClientConfiguration._getStringValue(name, "http.discoverServiceInterval", context, null);
                    if (discoverServiceInterval_ == null) {
                        httpServiceHosts.setDiscoverServiceInterval(10000L);
                    } else {
                        try {
                            httpServiceHosts.setDiscoverServiceInterval(Long.parseLong(discoverServiceInterval_));
                        }
                        catch (Exception e) {
                            if (!logger.isErrorEnabled()) break block29;
                            logger.error("Parse Long discoverServiceInterval parameter failed:" + discoverServiceInterval_, (Throwable)e);
                        }
                    }
                }
                String handleNullOrEmptyHostsByDiscovery_ = ClientConfiguration._getStringValue(name, "http.handleNullOrEmptyHostsByDiscovery", context, null);
                if (handleNullOrEmptyHostsByDiscovery_ == null) {
                    httpServiceHosts.setHandleNullOrEmptyHostsByDiscovery(false);
                } else {
                    try {
                        httpServiceHosts.setHandleNullOrEmptyHostsByDiscovery(Boolean.parseBoolean(handleNullOrEmptyHostsByDiscovery_));
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) break block30;
                        logger.error("Parse Boolean handleNullOrEmptyHostsByDiscovery_ parameter failed:" + handleNullOrEmptyHostsByDiscovery_, (Throwable)e);
                    }
                }
            }
            httpServiceHosts.toString(log);
            clientConfiguration.httpServiceHosts = httpServiceHosts;
            if (logger.isInfoEnabled()) {
                logger.info("Http Pool[{}] config:{}", (Object)name, (Object)log.toString());
            }
            clientConfiguration.afterPropertiesSet();
            if (httpServiceHosts != null) {
                httpServiceHosts.after(name, context);
            }
            clientConfigs.put(name, clientConfiguration);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return clientConfiguration;
        }
    }

    public static void bootClientConfiguations(String[] serverNames, GetProperties context) {
        for (String serverName : serverNames) {
            ClientConfiguration.configClientConfiguation(serverName, context);
        }
    }

    private static ClientConfiguration configClientConfiguation(String poolname, GetProperties context) {
        if (poolname == null || poolname.equals("default")) {
            return ClientConfiguration._getDefaultClientConfiguration(context);
        }
        try {
            return ClientConfiguration.makeDefualtClientConfiguration(poolname, context);
        }
        catch (Exception e) {
            throw new ConfigHttpRuntimeException("makeDefualtClientConfiguration [" + poolname + "] failed:", e);
        }
    }

    public static ClientConfiguration getClientConfiguration(String poolname) {
        ClientConfiguration.loadClientConfiguration();
        if (poolname == null) {
            return ClientConfiguration.getDefaultClientConfiguration();
        }
        try {
            return ClientConfiguration.makeDefualtClientConfiguration(poolname);
        }
        catch (Exception e) {
            throw new ConfigHttpRuntimeException("makeDefualtClientConfiguration [" + poolname + "] failed:", e);
        }
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(String supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public void setSoKeepAlive(Boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public Boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public void setSoReuseAddress(Boolean soReuseAddress) {
        this.soReuseAddress = soReuseAddress;
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(int validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection;
    }

    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    public int getTimeoutSocket() {
        return this.timeoutSocket;
    }

    public void setTimeoutSocket(int timeoutSocket) {
        this.timeoutSocket = timeoutSocket;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    private SSLConnectionSocketFactory buildSSLConnectionSocketFactory() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        if (this.keystore == null || this.keystore.equals("")) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            return new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(new File(this.keystore), this.keyPassword.toCharArray(), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        Object hostnameVerifier = this.hostnameVerifier != null ? this.hostnameVerifier : SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, this._supportedProtocols, null, (HostnameVerifier)hostnameVerifier);
        return sslsf;
    }

    public final CloseableHttpClient getHttpClient() throws Exception {
        if (this.httpclient != null) {
            return this.httpclient;
        }
        SSLConnectionSocketFactory SSLConnectionSocketFactory2 = this.buildSSLConnectionSocketFactory();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)SSLConnectionSocketFactory2).build();
        SystemDefaultDnsResolver dnsResolver = new SystemDefaultDnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                if (host.equalsIgnoreCase("localhost")) {
                    return new InetAddress[]{InetAddress.getByAddress(new byte[]{127, 0, 0, 1})};
                }
                return super.resolve(host);
            }
        };
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, null, null, (DnsResolver)dnsResolver, (long)this.timeToLive, TimeUnit.MILLISECONDS);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.timeoutSocket).setSoKeepAlive(this.soKeepAlive.booleanValue()).setSoReuseAddress(this.soReuseAddress.booleanValue()).build();
        connManager.setDefaultSocketConfig(socketConfig);
        connManager.setValidateAfterInactivity(this.validateAfterInactivity);
        MessageConstraints messageConstraints = MessageConstraints.custom().setMaxHeaderCount(this.maxHeaderCount).setMaxLineLength(this.maxLineLength).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).setMessageConstraints(messageConstraints).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        connManager.setMaxTotal(this.maxTotal);
        connManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectTimeout(this.timeoutConnection).setConnectionRequestTimeout(this.connectionRequestTimeout).setSocketTimeout(this.timeoutSocket).setStaleConnectionCheckEnabled(this.staleConnectionCheckEnabled).build();
        HttpClientBuilder builder = HttpClients.custom();
        if (this.keepAlive > 0L) {
            HttpConnectionKeepAliveStrategy httpConnectionKeepAliveStrategy = new HttpConnectionKeepAliveStrategy(this.keepAlive);
            builder.setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore((CookieStore)cookieStore).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy((ConnectionKeepAliveStrategy)httpConnectionKeepAliveStrategy);
            this.buildRetryHandler(builder);
            this.httpclient = builder.build();
        } else {
            builder.setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore((CookieStore)cookieStore).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfig);
            this.buildRetryHandler(builder);
            this.httpclient = builder.build();
        }
        if (this.beanName.equals("default")) {
            defaultRequestConfig = requestConfig;
            defaultHttpclient = this.httpclient;
        }
        clientConfigs.put(this.beanName, this);
        return this.httpclient;
    }

    private void buildRetryHandler(HttpClientBuilder builder) {
        if (this.getRetryTime() > 0) {
            CustomHttpRequestRetryHandler customHttpRequestRetryHandler = null;
            if (this.customHttpRequestRetryHandler != null && !this.customHttpRequestRetryHandler.trim().equals("")) {
                try {
                    customHttpRequestRetryHandler = (CustomHttpRequestRetryHandler)Class.forName(this.customHttpRequestRetryHandler).newInstance();
                }
                catch (Exception e) {
                    logger.error("Create CustomHttpRequestRetryHandler[" + this.customHttpRequestRetryHandler + "] failed:", (Throwable)e);
                    customHttpRequestRetryHandler = defaultHttpRequestRetryHandler;
                }
            } else {
                customHttpRequestRetryHandler = defaultHttpRequestRetryHandler;
            }
            HttpRequestRetryHandlerHelper httpRequestRetryHandlerHelper = new HttpRequestRetryHandlerHelper(customHttpRequestRetryHandler, this);
            builder.setRetryHandler((HttpRequestRetryHandler)httpRequestRetryHandlerHelper);
        }
    }

    public HttpClient getHttpclient() {
        return this.httpclient;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public void afterPropertiesSet() throws Exception {
        this._supportedProtocols = this.supportedProtocols != null && !this.supportedProtocols.equals("") ? this.supportedProtocols.split(",") : this.defaultSupportedProtocols;
        this.getHttpClient();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isStaleConnectionCheckEnabled() {
        return this.staleConnectionCheckEnabled;
    }

    public void setStaleConnectionCheckEnabled(boolean staleConnectionCheckEnabled) {
        this.staleConnectionCheckEnabled = staleConnectionCheckEnabled;
    }

    public String getCustomHttpRequestRetryHandler() {
        return this.customHttpRequestRetryHandler;
    }

    public void setCustomHttpRequestRetryHandler(String customHttpRequestRetryHandler) {
        this.customHttpRequestRetryHandler = customHttpRequestRetryHandler;
    }

    public String getHostnameVerifierString() {
        return this.hostnameVerifierString;
    }

    public void setHostnameVerifierString(String hostnameVerifierString) {
        this.hostnameVerifierString = hostnameVerifierString;
    }

    public GetProperties getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(GetProperties contextProperties) {
        this.contextProperties = contextProperties;
    }

    static {
        clientConfigs = new HashMap<String, ClientConfiguration>();
    }
}

