/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.balance;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.balance.NoServerException;
import org.frameworkset.balance.Node;

public class RoundRobinList<T extends Node> {
    private final List<T> elements;
    private Iterator<T> iterator;
    private String message;
    private final Lock lock = new ReentrantLock();

    public RoundRobinList(List<T> elements) {
        this.elements = elements;
        this.message = "All server " + elements.toString() + " can't been connected.";
        this.iterator = this.elements.iterator();
    }

    public void addAddresses(List<T> address) {
        this.lock.lock();
        try {
            this.elements.addAll(address);
            this.message = "All server " + this.elements.toString() + " can't been connected.";
            this.iterator = this.elements.iterator();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T _get() {
        this.lock.lock();
        try {
            Node address2 = null;
            Node temp = null;
            while (this.iterator.hasNext()) {
                address2 = (Node)this.iterator.next();
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                Node node = temp;
                return (T)node;
            }
            for (Node address2 : this.elements) {
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            Node node = temp;
            return (T)node;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T _getOkOrFailed() {
        this.lock.lock();
        try {
            Node address2 = null;
            Node temp = null;
            while (this.iterator.hasNext()) {
                address2 = (Node)this.iterator.next();
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                Node node = temp;
                return (T)node;
            }
            for (Node address2 : this.elements) {
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            Node node = temp;
            return (T)node;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T get(boolean failAllContinue) {
        T esAddress = this._get();
        if (esAddress != null) {
            return esAddress;
        }
        if (!failAllContinue) {
            throw new NoServerException(this.message);
        }
        esAddress = this._getOkOrFailed();
        if (esAddress != null) {
            return esAddress;
        }
        throw new NoServerException(this.message);
    }

    public int size() {
        return this.elements.size();
    }
}

