/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support.validate;

import com.frameworkset.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.frameworkset.spi.support.validate.Errors;
import org.frameworkset.spi.support.validate.FieldError;
import org.frameworkset.spi.support.validate.ObjectError;

public class EscapedErrors
implements Errors {
    private final Errors source;

    public EscapedErrors(Errors source) {
        if (source == null) {
            throw new IllegalArgumentException("Cannot wrap a null instance");
        }
        this.source = source;
    }

    public Errors getSource() {
        return this.source;
    }

    @Override
    public String getObjectName() {
        return this.source.getObjectName();
    }

    @Override
    public void setNestedPath(String nestedPath) {
        this.source.setNestedPath(nestedPath);
    }

    @Override
    public String getNestedPath() {
        return this.source.getNestedPath();
    }

    @Override
    public void pushNestedPath(String subPath) {
        this.source.pushNestedPath(subPath);
    }

    @Override
    public void popNestedPath() throws IllegalStateException {
        this.source.popNestedPath();
    }

    @Override
    public void reject(String errorCode) {
        this.source.reject(errorCode);
    }

    @Override
    public void reject(String errorCode, String defaultMessage) {
        this.source.reject(errorCode, defaultMessage);
    }

    @Override
    public void rejectWithErrorArgs(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.source.rejectWithErrorArgs(errorCode, errorArgs, defaultMessage);
    }

    @Override
    public void rejectValue(String field, String errorCode) {
        this.source.rejectValue(field, errorCode);
    }

    @Override
    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.source.rejectValue(field, errorCode, defaultMessage);
    }

    @Override
    public void rejectValueWithErrorArgs(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.source.rejectValueWithErrorArgs(field, errorCode, errorArgs, defaultMessage);
    }

    @Override
    public void addAllErrors(Errors errors) {
        this.source.addAllErrors(errors);
    }

    @Override
    public boolean hasErrors() {
        return this.source.hasErrors();
    }

    @Override
    public int getErrorCount() {
        return this.source.getErrorCount();
    }

    @Override
    public List getAllErrors() {
        return this.escapeObjectErrors(this.source.getAllErrors());
    }

    @Override
    public boolean hasGlobalErrors() {
        return this.source.hasGlobalErrors();
    }

    @Override
    public int getGlobalErrorCount() {
        return this.source.getGlobalErrorCount();
    }

    @Override
    public List getGlobalErrors() {
        return this.escapeObjectErrors(this.source.getGlobalErrors());
    }

    @Override
    public ObjectError getGlobalError() {
        return this.escapeObjectError(this.source.getGlobalError());
    }

    @Override
    public boolean hasFieldErrors() {
        return this.source.hasFieldErrors();
    }

    @Override
    public int getFieldErrorCount() {
        return this.source.getFieldErrorCount();
    }

    @Override
    public List getFieldErrors() {
        return this.source.getFieldErrors();
    }

    @Override
    public boolean hasFieldErrors(String field) {
        return this.source.hasFieldErrors(field);
    }

    @Override
    public FieldError getFieldError(String field) {
        return (FieldError)this.escapeObjectError(this.source.getFieldError(field));
    }

    @Override
    public Object getFieldValue(String field) {
        Object value = this.source.getFieldValue(field);
        return value instanceof String ? HtmlUtils.htmlEscape((String)((String)value)) : value;
    }

    private ObjectError escapeObjectError(ObjectError source) {
        if (source == null) {
            return null;
        }
        if (source instanceof FieldError) {
            FieldError fieldError = (FieldError)source;
            Object value = fieldError.getRejectedValue();
            if (value instanceof String) {
                value = HtmlUtils.htmlEscape((String)((String)value));
            }
            return new FieldError(fieldError.getObjectName(), fieldError.getField(), value, fieldError.getType(), fieldError.isBindingFailure(), fieldError.getCodes(), fieldError.getArguments(), HtmlUtils.htmlEscape((String)fieldError.getDefaultMessage()));
        }
        return new ObjectError(source.getObjectName(), source.getCodes(), source.getArguments(), HtmlUtils.htmlEscape((String)source.getDefaultMessage()));
    }

    private List escapeObjectErrors(List source) {
        ArrayList<ObjectError> escaped = new ArrayList<ObjectError>(source.size());
        for (ObjectError objectError : source) {
            escaped.add(this.escapeObjectError(objectError));
        }
        return escaped;
    }

    @Override
    public Object getTarget() {
        return this.source.getTarget();
    }

    @Override
    public void rejectValue(String field, String errorCode, String rejectvalue, String defaultMessage) {
        this.source.rejectValue(field, errorCode, rejectvalue, defaultMessage);
    }

    @Override
    public void rejectValue(String field, String errorCode, String[] rejectvalue, String defaultMessage) {
        this.source.rejectValue(field, errorCode, rejectvalue, defaultMessage);
    }

    @Override
    public void rejectValue(String field, String errorCode, String rejectvalue, Class fieldtype, String defaultMessage) {
        this.source.rejectValue(field, errorCode, rejectvalue, fieldtype, defaultMessage);
    }

    @Override
    public void rejectValue(String field, String errorCode, String[] rejectvalue, Class fieldtype, String defaultMessage) {
        this.source.rejectValue(field, errorCode, rejectvalue, fieldtype, defaultMessage);
    }

    @Override
    public void rejectValueWithErrorArgs(String field, String errorCode, Object[] errorArgs) {
        this.source.rejectValueWithErrorArgs(field, errorCode, errorArgs);
    }

    @Override
    public void rejectWithErrorArgs(String errorCode, Object[] errorArgs) {
        this.rejectWithErrorArgs(errorCode, errorArgs, null);
    }

    @Override
    public int getFieldErrorCount(String field) {
        return this.source.getFieldErrorCount(field);
    }

    @Override
    public List getFieldErrors(String field) {
        return this.source.getFieldErrors(field);
    }
}

