/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import com.frameworkset.util.SimpleStringUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.TimeMetric;
import org.frameworkset.tran.metrics.job.BaseMetrics;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.MetricUtil;
import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.frameworkset.tran.metrics.job.PersistentDataHolder;
import org.frameworkset.tran.metrics.job.PersistentScanCallback;
import org.frameworkset.tran.metrics.job.TimeMetricHolder;
import org.frameworkset.tran.metrics.job.TimeMetricsScanTask;
import org.frameworkset.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeKeyMetrics
implements BaseMetrics {
    private String metricsName = "TimeKeyMetrics";
    protected int segmentBoundSize = 100000;
    private Map<String, TimeMetricHolder> timeMetricHolders = new LinkedHashMap<String, TimeMetricHolder>();
    private ReentrantLock write = new ReentrantLock();
    private static Logger logger = LoggerFactory.getLogger(TimeKeyMetrics.class);
    private TimeMetricsScanTask metricsThread;
    private MetricsConfig metricsConfig;
    private KeyMetricsPersistent metricsPersistent;
    private int timeWindowType = 2;
    private long scanInterval = 5000L;
    private int timeWindows = 60;
    private boolean stoped;
    private Object stopLock = new Object();

    public void setSegmentBoundSize(int segmentBoundSize) {
        this.segmentBoundSize = segmentBoundSize;
    }

    public int getTimeWindowType() {
        return this.timeWindowType;
    }

    public void setTimeWindowType(int timeWindowType) {
        this.timeWindowType = timeWindowType;
    }

    public void setTimeWindows(int timeWindows) {
        this.timeWindows = timeWindows;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval;
    }

    @Override
    public void init() {
        MetricsConfig metricsConfig = new MetricsConfig();
        metricsConfig.setScanInterval(this.scanInterval);
        if (this.timeWindows > 0) {
            metricsConfig.setTimeWindows(0 - this.timeWindows);
        } else if (this.timeWindows < 0) {
            metricsConfig.setTimeWindows(this.timeWindows);
        } else {
            metricsConfig.setTimeWindows(-300);
        }
        this.metricsConfig = metricsConfig;
        KeyMetricsPersistent metricsPersistent = new KeyMetricsPersistent("TimeKeyMetrics");
        metricsPersistent.setPersistent(this);
        metricsPersistent.init();
        this.metricsPersistent = metricsPersistent;
        TimeMetricsScanTask scanTask = new TimeMetricsScanTask("ScanTask-" + this.metricsName);
        scanTask.setMetricsConfig(metricsConfig);
        scanTask.setMetrics(this);
        scanTask.start();
        this.metricsThread = scanTask;
    }

    @Override
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    private boolean needPersistent(Date slot, KeyMetric metric) {
        return metric.getSlotTime().before(slot);
    }

    public DateFormat getMetricsTimeKeyFormat(MapData data) {
        return MetricUtil.getMetricsTimeKeyFormat(this.timeWindowType, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMetrics() {
        if (this.stoped) {
            return;
        }
        Object object = this.stopLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        if (this.metricsThread != null) {
            this.metricsThread.stopScan();
        }
        this.stopTimeMetricHolder();
        if (this.metricsPersistent != null) {
            this.metricsPersistent.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceFlush(boolean clearMetricKey, boolean waitComplete) {
        long s = System.currentTimeMillis();
        logger.info("Force Flush timemetrics start.");
        ArrayList<String> emptyHolder = new ArrayList<String>();
        ArrayList<Future> futures = new ArrayList<Future>();
        this.write.lock();
        try {
            Iterator<Map.Entry<String, TimeMetricHolder>> iterator = this.timeMetricHolders.entrySet().iterator();
            while (iterator.hasNext()) {
                TimeMetricHolder timeMetricHolder2 = iterator.next().getValue();
                String metricsTimeKey = timeMetricHolder2.getMetricTimeKey();
                List<Future> temp = timeMetricHolder2.forceFlush(waitComplete);
                if (waitComplete && temp.size() > 0) {
                    futures.addAll(temp);
                }
                if (!timeMetricHolder2.isEmpty()) continue;
                emptyHolder.add(metricsTimeKey);
            }
            if (emptyHolder.size() > 0) {
                emptyHolder.forEach(timeMetricHolder -> this.timeMetricHolders.remove(timeMetricHolder));
            }
        }
        finally {
            this.write.unlock();
        }
        if (waitComplete && futures.size() > 0) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException metricsTimeKey) {
                }
                catch (ExecutionException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        logger.info("Force Flush timekeymetrics complete elapse:{} ms.", (Object)(System.currentTimeMillis() - s));
    }

    private void stopTimeMetricHolder() {
        this.write.lock();
        try {
            Iterator<Map.Entry<String, TimeMetricHolder>> iterator = this.timeMetricHolders.entrySet().iterator();
            while (iterator.hasNext()) {
                TimeMetricHolder timeMetricHolder = iterator.next().getValue();
                timeMetricHolder.stopMetrics();
            }
            this.timeMetricHolders.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeMetric metric(String metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        if (!metricBuilder.validateData(data)) {
            if (logger.isDebugEnabled()) {
                logger.debug("data validate failed:{}", (Object)SimpleStringUtil.object2json(data.getData()));
            }
            return null;
        }
        Date time = data.metricsDataTime(metricsKey);
        DateFormat dateFormat = this.getMetricsTimeKeyFormat(data);
        Date slotTime = new Date();
        String metricsTimeKey = dateFormat.format(time);
        String metricsSlotTime = dateFormat.format(slotTime);
        TimeMetricHolder timeMetricHolder = null;
        this.write.lock();
        try {
            TimeMetric metric;
            timeMetricHolder = this.timeMetricHolders.get(metricsTimeKey);
            if (timeMetricHolder == null) {
                timeMetricHolder = new TimeMetricHolder();
                timeMetricHolder.setMetricsSlotTimeKey(metricsSlotTime);
                timeMetricHolder.setMetricsPersistent(this.metricsPersistent);
                timeMetricHolder.setTimeMetrics(this);
                timeMetricHolder.setSlotTime(slotTime);
                timeMetricHolder.setSegmentBoundSize(this.segmentBoundSize);
                timeMetricHolder.setMetricTimeKey(metricsTimeKey);
                timeMetricHolder.init();
                this.timeMetricHolders.put(metricsTimeKey, timeMetricHolder);
            }
            TimeMetric timeMetric = metric = (TimeMetric)timeMetricHolder.metric(metricsKey, data, metricBuilder);
            return timeMetric;
        }
        finally {
            this.write.unlock();
        }
    }

    private void _persistent(Collection<KeyMetric> keyMetrics) {
        this.metricsPersistent.persistent(keyMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanPersistentMetrics() {
        if (logger.isDebugEnabled()) {
            logger.debug("Scan persistent timekey metrics begin.....");
        }
        long start = System.currentTimeMillis();
        final Date slot = TimeUtil.addDateSeconds((Date)new Date(), (int)this.metricsConfig.getTimeWindows());
        final PersistentDataHolder persistentData = new PersistentDataHolder();
        persistentData.init();
        ArrayList<String> emptyHolder = new ArrayList<String>();
        this.write.lock();
        try {
            Iterator<Map.Entry<String, TimeMetricHolder>> iterator = this.timeMetricHolders.entrySet().iterator();
            while (iterator.hasNext()) {
                TimeMetricHolder timeMetricHolder2 = iterator.next().getValue();
                String metricsTimeKey = timeMetricHolder2.getMetricTimeKey();
                if (!timeMetricHolder2.needPersistent(slot)) break;
                if (!timeMetricHolder2.isTimeWindowOlder(slot)) {
                    timeMetricHolder2.scanPersistentMetrics(new PersistentScanCallback(){

                        @Override
                        public boolean scanTimeMetric2Persistent(KeyMetric keyMetric) {
                            if (TimeKeyMetrics.this.needPersistent(slot, keyMetric)) {
                                persistentData.addKeyMetric(keyMetric);
                                return true;
                            }
                            return false;
                        }
                    });
                    if (!timeMetricHolder2.isEmpty()) continue;
                    emptyHolder.add(metricsTimeKey);
                    continue;
                }
                timeMetricHolder2.persisteMetrics();
                emptyHolder.add(metricsTimeKey);
            }
            if (persistentData != null && persistentData.size() > 0) {
                this._persistent(persistentData.getPersistentData());
                persistentData.clear();
            }
            if (emptyHolder.size() > 0) {
                emptyHolder.forEach(timeMetricHolder -> this.timeMetricHolders.remove(timeMetricHolder));
            }
        }
        finally {
            this.write.unlock();
        }
        if (logger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            logger.debug("Scan persistent timekey metrics complete,take times:{} ms", (Object)(end - start));
        }
    }
}

