/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TransactionContext {
    private static final ThreadLocal<Map<String, String>> CONTEXT_HOLDER = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    private static final String XID = "LOCAL_XID";

    public static String getXID() {
        String xid = CONTEXT_HOLDER.get().get(XID);
        if (!StringUtils.isEmpty((Object)xid)) {
            return xid;
        }
        return null;
    }

    public static String unbind(String xid) {
        CONTEXT_HOLDER.get().remove(xid);
        return xid;
    }

    public static String bind(String xid) {
        CONTEXT_HOLDER.get().put(XID, xid);
        return xid;
    }

    public static void remove() {
        CONTEXT_HOLDER.remove();
    }
}

