/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.toolkit;

import java.util.concurrent.LinkedBlockingDeque;

public final class DynamicDataSourceContextHolder {
    private static final ThreadLocal<LinkedBlockingDeque<String>> LOOKUP_KEY_HOLDER = new ThreadLocal(){

        protected Object initialValue() {
            return new LinkedBlockingDeque();
        }
    };

    private DynamicDataSourceContextHolder() {
    }

    public static String getDataSourceLookupKey() {
        LinkedBlockingDeque<String> deque = LOOKUP_KEY_HOLDER.get();
        return deque.isEmpty() ? null : deque.getFirst();
    }

    public static void setDataSourceLookupKey(String dataSourceLookupKey) {
        LOOKUP_KEY_HOLDER.get().addFirst(dataSourceLookupKey);
    }

    public static void clearDataSourceLookupKey() {
        LinkedBlockingDeque<String> deque = LOOKUP_KEY_HOLDER.get();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        } else {
            deque.pollFirst();
        }
    }
}

