/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.models.PtrRecord;
import com.azure.resourcemanager.dns.models.PtrRecordSet;
import com.azure.resourcemanager.dns.models.RecordType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PtrRecordSetImpl
extends DnsRecordSetImpl
implements PtrRecordSet {
    PtrRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.PTR.toString(), parent, innerModel);
    }

    static PtrRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new PtrRecordSetImpl(name, parent, new RecordSetInner().withPtrRecords(new ArrayList<PtrRecord>()));
    }

    @Override
    public List<String> targetDomainNames() {
        ArrayList<String> targetDomainNames = new ArrayList<String>();
        if (((RecordSetInner)((Object)this.innerModel())).ptrRecords() != null) {
            for (PtrRecord ptrRecord : ((RecordSetInner)((Object)this.innerModel())).ptrRecords()) {
                targetDomainNames.add(ptrRecord.ptrdname());
            }
        }
        return Collections.unmodifiableList(targetDomainNames);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)((Object)this.innerModel())).ptrRecords() != null && ((RecordSetInner)((Object)this.innerModel())).ptrRecords().size() > 0) {
            if (resource.ptrRecords() == null) {
                resource.withPtrRecords(new ArrayList<PtrRecord>());
            }
            resource.ptrRecords().addAll(((RecordSetInner)((Object)this.innerModel())).ptrRecords());
            ((RecordSetInner)((Object)this.innerModel())).ptrRecords().clear();
        }
        if (this.recordSetRemoveInfo.ptrRecords().size() > 0) {
            if (resource.ptrRecords() != null) {
                block0: for (PtrRecord recordToRemove : this.recordSetRemoveInfo.ptrRecords()) {
                    for (PtrRecord record : resource.ptrRecords()) {
                        if (!record.ptrdname().equalsIgnoreCase(recordToRemove.ptrdname())) continue;
                        resource.ptrRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.ptrRecords().clear();
        }
        return resource;
    }
}

