/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dns.DnsZoneManager;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.CnameRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetsBaseImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.models.CnameRecordSet;
import com.azure.resourcemanager.dns.models.CnameRecordSets;
import com.azure.resourcemanager.dns.models.RecordType;
import reactor.core.publisher.Mono;

class CnameRecordSetsImpl
extends DnsRecordSetsBaseImpl<CnameRecordSet, CnameRecordSetImpl>
implements CnameRecordSets {
    CnameRecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.CNAME);
    }

    public CnameRecordSet getByName(String name) {
        return (CnameRecordSet)this.getByNameAsync(name).block();
    }

    public Mono<CnameRecordSet> getByNameAsync(String name) {
        return ((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().getAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType).map(this::wrapModel);
    }

    @Override
    protected PagedIterable<CnameRecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix, Context.NONE));
    }

    @Override
    protected PagedFlux<CnameRecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected CnameRecordSetImpl wrapModel(RecordSetInner inner) {
        if (inner == null) {
            return null;
        }
        return new CnameRecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

