/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.IndoubtStateHandler;
import com.atomikos.icatch.imp.PrepareMessage;
import com.atomikos.icatch.imp.PrepareResult;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.imp.thread.InterruptedExceptionHelper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

class ActiveStateHandler
extends CoordinatorStateHandler {
    private static final long serialVersionUID = -80097456886481668L;
    private static final Logger LOGGER = LoggerFactory.createLogger(ActiveStateHandler.class);
    private long rollbackTicks_ = 0L;
    private int globalSiblingCount_;

    ActiveStateHandler(CoordinatorImp coordinator) {
        super(coordinator);
    }

    protected long getRollbackTicks() {
        return this.rollbackTicks_;
    }

    protected Object getState() {
        return TxState.ACTIVE;
    }

    protected void onTimeout() {
        try {
            if (this.rollbackTicks_ < this.getCoordinator().getMaxRollbackTicks()) {
                ++this.rollbackTicks_;
            } else if (this.getCoordinator().getState().equals(this.getState())) {
                if (this.getCoordinator().prefersSingleThreaded2PC()) {
                    LOGGER.logWarning("Timeout/setRollbackOnly of ACTIVE coordinator !");
                    this.getCoordinator().setRollbackOnly();
                } else {
                    LOGGER.logWarning("Rollback of timedout ACTIVE coordinator !");
                    boolean indoubt = this.getCoordinator().isRecoverableWhileActive();
                    super.rollback(indoubt, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.logInfo("Error in timeout of ACTIVE state: " + e.getMessage() + " for coordinator " + this.getCoordinator().getCoordinatorId());
        }
    }

    protected void setGlobalSiblingCount(int count) {
        this.globalSiblingCount_ = count;
    }

    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        CoordinatorStateHandler nextStateHandler;
        int ret;
        boolean allReadOnly;
        block18: {
            Stack<Throwable> errors = new Stack<Throwable>();
            int count = 0;
            PrepareResult result = null;
            allReadOnly = true;
            ret = 0;
            Vector participants = this.getCoordinator().getParticipants();
            nextStateHandler = null;
            if (this.orphansExist()) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("Orphans detected: " + this.getCoordinator().getLocalSiblingCount() + " vs " + this.globalSiblingCount_ + " - forcing rollback.");
                    }
                    super.rollback(this.getCoordinator().isRecoverableWhileActive(), false);
                }
                catch (HeurCommitException hc) {
                    throw new HeurMixedException(hc.getHeuristicMessages());
                }
                throw new RollbackException("Orphans detected.");
            }
            try {
                try {
                    this.getCoordinator().setState(TxState.PREPARING);
                }
                catch (RuntimeException error) {
                    String msg = "Error in preparing: " + error.getMessage() + " - rolling back instead";
                    LOGGER.logWarning(msg, (Throwable)error);
                    try {
                        super.rollback(this.getCoordinator().isRecoverableWhileActive(), false);
                        throw new RollbackException(msg);
                    }
                    catch (HeurCommitException e) {
                        LOGGER.logWarning("Illegal heuristic commit during rollback before prepare:" + (Object)((Object)e));
                        throw new HeurMixedException(e.getHeuristicMessages());
                    }
                }
                count = participants.size();
                result = new PrepareResult(count);
                Enumeration enumm = participants.elements();
                while (enumm.hasMoreElements()) {
                    Participant p = (Participant)enumm.nextElement();
                    PrepareMessage pm = new PrepareMessage(p, result);
                    if (this.getCascadeList() != null && p.getURI() != null) {
                        Integer sibnum = (Integer)this.getCascadeList().get(p.getURI());
                        if (sibnum != null) {
                            p.setGlobalSiblingCount(sibnum.intValue());
                        }
                        p.setCascadeList(this.getCascadeList());
                    }
                    this.getPropagator().submitPropagationMessage(pm);
                }
                result.waitForReplies();
                boolean voteOK = result.allYes();
                this.setReadOnlyTable(result.getReadOnlyTable());
                allReadOnly = result.allReadOnly();
                if (voteOK) break block18;
                int res = result.getResult();
                try {
                    this.rollback(true, false);
                }
                catch (HeurCommitException hc) {
                    errors.push(hc);
                    throw new SysException("Unexpected heuristic: " + hc.getMessage(), errors);
                }
                throw new RollbackException("Prepare: NO vote");
            }
            catch (RuntimeException runerr) {
                errors.push(runerr);
                throw new SysException("Error in prepare: " + runerr.getMessage(), errors);
            }
            catch (InterruptedException err) {
                InterruptedExceptionHelper.handleInterruptedException(err);
                errors.push(err);
                throw new SysException("Error in prepare: " + err.getMessage(), errors);
            }
        }
        if (allReadOnly) {
            nextStateHandler = new TerminatedStateHandler(this);
            this.getCoordinator().setStateHandler(nextStateHandler);
            ret = 0;
        } else {
            nextStateHandler = new IndoubtStateHandler(this);
            this.getCoordinator().setStateHandler(nextStateHandler);
            ret = 1;
        }
        return ret;
    }

    private boolean orphansExist() {
        return this.getCoordinator().checkSiblings() && this.globalSiblingCount_ != this.getCoordinator().getLocalSiblingCount();
    }

    protected HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        HeuristicMessage[] result = new HeuristicMessage[]{};
        if (!onePhase) {
            throw new IllegalStateException("Illegal state for commit: ACTIVE!");
        }
        if (this.getCoordinator().getParticipants().size() > 1) {
            int prepareResult = 1;
            this.setGlobalSiblingCount(1);
            prepareResult = this.prepare();
            result = prepareResult == 0 ? this.getHeuristicMessages() : this.commit(false, false);
        } else {
            result = this.commit(false, true);
        }
        return result;
    }

    protected HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        return this.rollback(this.getCoordinator().isRecoverableWhileActive(), false);
    }

    protected Boolean replayCompletion(Participant participant) throws IllegalStateException {
        throw new IllegalStateException("No prepares sent yet.");
    }
}

