/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsResponse;
import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.ISignatureComposer;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.regions.ProductDomain;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AcsRequest<T extends AcsResponse>
extends HttpRequest {
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> domainParameters = new HashMap<String, String>();
    private final Map<String, String> bodyParameters = new HashMap<String, String>();
    protected ISignatureComposer composer = null;
    private String version = null;
    private String product = null;
    private String actionName = null;
    private String regionId = null;
    private String securityToken = null;
    private FormatType acceptFormat = null;
    private ProtocolType protocol = null;
    private String locationProduct;
    private String endpointType;
    private ProductDomain productDomain = null;
    protected String strToSign;

    public AcsRequest(String product) {
        super(null);
        this.headers.put("x-sdk-client", "Java/2.0.0");
        this.headers.put("x-sdk-invoke-type", "normal");
        this.product = product;
    }

    public static String concatQueryString(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (null == parameters) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder("");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            urlBuilder.append(AcsURLEncoder.encode(key));
            if (val != null) {
                urlBuilder.append("=").append(AcsURLEncoder.encode(val));
            }
            urlBuilder.append("&");
        }
        int strIndex = urlBuilder.length();
        if (parameters.size() > 0) {
            urlBuilder.deleteCharAt(strIndex - 1);
        }
        return urlBuilder.toString();
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        ProductDomain productDomain = new ProductDomain(this.product, endpoint);
        this.setProductDomain(productDomain);
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public String getProduct() {
        return this.product;
    }

    @Deprecated
    public String getActionName() {
        return this.actionName;
    }

    @Deprecated
    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Deprecated
    public String getRegionId() {
        return this.regionId;
    }

    @Deprecated
    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    @Deprecated
    public String getSecurityToken() {
        return this.securityToken;
    }

    @Deprecated
    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        this.putQueryParameter("SecurityToken", securityToken);
    }

    @Deprecated
    public FormatType getAcceptFormat() {
        return this.acceptFormat;
    }

    @Deprecated
    public void setAcceptFormat(FormatType acceptFormat) {
        this.acceptFormat = acceptFormat;
        this.putHeaderParameter("Accept", FormatType.mapFormatToAccept(acceptFormat));
    }

    @Deprecated
    public ProtocolType getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public void setProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    @Deprecated
    public Map<String, String> getQueryParameters() {
        return Collections.unmodifiableMap(this.queryParameters);
    }

    public Map<String, String> getSysQueryParameters() {
        return Collections.unmodifiableMap(this.queryParameters);
    }

    public <K> void putQueryParameter(String name, K value) {
        this.setParameter(this.queryParameters, name, value);
    }

    protected void putQueryParameter(String name, String value) {
        this.setParameter(this.queryParameters, name, value);
    }

    @Deprecated
    public Map<String, String> getDomainParameters() {
        return Collections.unmodifiableMap(this.domainParameters);
    }

    public Map<String, String> getSysDomainParameters() {
        return Collections.unmodifiableMap(this.domainParameters);
    }

    protected void putDomainParameter(String name, Object value) {
        this.setParameter(this.domainParameters, name, value);
    }

    @Deprecated
    public Map<String, String> getBodyParameters() {
        return Collections.unmodifiableMap(this.bodyParameters);
    }

    public Map<String, String> getSysBodyParameters() {
        return Collections.unmodifiableMap(this.bodyParameters);
    }

    protected void putDomainParameter(String name, String value) {
        this.setParameter(this.domainParameters, name, value);
    }

    protected void putBodyParameter(String name, Object value) {
        this.setParameter(this.bodyParameters, name, value);
    }

    protected void setParameter(Map<String, String> map, String name, Object value) {
        if (null == map || null == name || null == value) {
            return;
        }
        map.put(name, String.valueOf(value));
    }

    @Deprecated
    public String getLocationProduct() {
        return this.locationProduct;
    }

    @Deprecated
    public void setLocationProduct(String locationProduct) {
        this.locationProduct = locationProduct;
        this.putQueryParameter("ServiceCode", locationProduct);
    }

    @Deprecated
    public String getEndpointType() {
        return this.endpointType;
    }

    @Deprecated
    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
        this.putQueryParameter("Type", endpointType);
    }

    @Deprecated
    public ProductDomain getProductDomain() {
        return this.productDomain;
    }

    @Deprecated
    public void setProductDomain(ProductDomain productDomain) {
        this.productDomain = productDomain;
    }

    public abstract HttpRequest signRequest(Signer var1, AlibabaCloudCredentials var2, FormatType var3, ProductDomain var4) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException;

    public abstract String composeUrl(String var1, Map<String, String> var2) throws UnsupportedEncodingException;

    public abstract Class<T> getResponseClass();

    public String getSysVersion() {
        return this.version;
    }

    public void setSysVersion(String version) {
        this.version = version;
    }

    public String getSysProduct() {
        return this.product;
    }

    public String getSysActionName() {
        return this.actionName;
    }

    public void setSysActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getSysRegionId() {
        return this.regionId;
    }

    public void setSysRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getSysSecurityToken() {
        return this.securityToken;
    }

    public void setSysSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        this.putQueryParameter("SecurityToken", securityToken);
    }

    public FormatType getSysAcceptFormat() {
        return this.acceptFormat;
    }

    public void setSysAcceptFormat(FormatType acceptFormat) {
        this.acceptFormat = acceptFormat;
        this.putHeaderParameter("Accept", FormatType.mapFormatToAccept(acceptFormat));
    }

    public ProtocolType getSysProtocol() {
        return this.protocol;
    }

    public void setSysProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public void setSysEndpoint(String endpoint) {
        ProductDomain productDomain = new ProductDomain(this.product, endpoint);
        this.setSysProductDomain(productDomain);
    }

    public String getSysLocationProduct() {
        return this.locationProduct;
    }

    public void setSysLocationProduct(String locationProduct) {
        this.locationProduct = locationProduct;
        this.putQueryParameter("ServiceCode", locationProduct);
    }

    public String getSysEndpointType() {
        return this.endpointType;
    }

    public void setSysEndpointType(String endpointType) {
        this.endpointType = endpointType;
        this.putQueryParameter("Type", endpointType);
    }

    public ProductDomain getSysProductDomain() {
        return this.productDomain;
    }

    public void setSysProductDomain(ProductDomain productDomain) {
        this.productDomain = productDomain;
    }
}

