/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairts.params;

import com.aliyun.tair.jedis3.Params;
import com.aliyun.tair.tairts.params.ExtsFilter;
import java.util.ArrayList;
import java.util.Arrays;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class ExtsAggregationParams
extends Params {
    private static final String MAXCOUNT = "MAXCOUNT";
    private static final String WITHLABELS = "WITHLABELS";
    private static final String REVERSE = "REVERSE";
    private static final String FILTER = "FILTER";
    private static final String AGGREGATION = "AGGREGATION";
    private static final String MIN = "MIN";
    private static final String MAX = "MAX";
    private static final String SUM = "SUM";
    private static final String AVG = "AVG";
    private static final String STDP = "STD.P";
    private static final String STDS = "STD.S";
    private static final String COUNT = "COUNT";
    private static final String FIRST = "FIRST";
    private static final String LAST = "LAST";
    private static final String RANGE = "RANGE";
    private static final ArrayList<String> MENUS = new ArrayList<String>(Arrays.asList("MIN", "MAX", "SUM", "AVG", "STD.P", "STD.S", "COUNT", "FIRST", "LAST", "RANGE"));

    public ExtsAggregationParams withLabels() {
        this.addParam(WITHLABELS);
        return this;
    }

    public ExtsAggregationParams reverse() {
        this.addParam(REVERSE);
        return this;
    }

    public ExtsAggregationParams maxCountSize(long count) {
        this.addParam(MAXCOUNT, count);
        return this;
    }

    public ExtsAggregationParams aggMin(long timeBucket) {
        this.addParam(MIN, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggMax(long timeBucket) {
        this.addParam(MAX, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggSum(long timeBucket) {
        this.addParam(SUM, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggAvg(long timeBucket) {
        this.addParam(AVG, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggStdP(long timeBucket) {
        this.addParam(STDP, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggStdS(long timeBucket) {
        this.addParam(STDS, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggCount(long timeBucket) {
        this.addParam(COUNT, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggFirst(long timeBucket) {
        this.addParam(FIRST, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggLast(long timeBucket) {
        this.addParam(LAST, timeBucket);
        return this;
    }

    public ExtsAggregationParams aggRange(long timeBucket) {
        this.addParam(RANGE, timeBucket);
        return this;
    }

    private void addParamWithValue(ArrayList<byte[]> byteParams, String option) {
        if (this.contains(option)) {
            byteParams.add(SafeEncoder.encode((String)option));
            byteParams.add(SafeEncoder.encode((String)String.valueOf(this.getParam(option))));
        }
    }

    public byte[][] getByteRangeParams(String ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (String arg : args) {
            byteParams.add(SafeEncoder.encode((String)arg));
        }
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        for (String menu : MENUS) {
            if (!this.contains(menu)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, menu);
            break;
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getByteRangeParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (byte[] arg : args) {
            byteParams.add(arg);
        }
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        Object object = MENUS.iterator();
        while (object.hasNext()) {
            String menu = (String)object.next();
            if (!this.contains(menu)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, menu);
            break;
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getByteRangeParams(String pkey, ArrayList<String> skeys, String startTs, String endTs) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(SafeEncoder.encode((String)pkey));
        byteParams.add(Protocol.toByteArray((int)skeys.size()));
        for (String arg : skeys) {
            byteParams.add(SafeEncoder.encode((String)arg));
        }
        byteParams.add(SafeEncoder.encode((String)startTs));
        byteParams.add(SafeEncoder.encode((String)endTs));
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        if (this.contains(WITHLABELS)) {
            byteParams.add(SafeEncoder.encode((String)WITHLABELS));
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        for (String menu : MENUS) {
            if (!this.contains(menu)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, menu);
            break;
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getByteRangeParams(byte[] pkey, ArrayList<byte[]> skeys, byte[] startTs, byte[] endTs) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(pkey);
        byteParams.add(Protocol.toByteArray((int)skeys.size()));
        for (byte[] arg : skeys) {
            byteParams.add(arg);
        }
        byteParams.add(startTs);
        byteParams.add(endTs);
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        if (this.contains(WITHLABELS)) {
            byteParams.add(SafeEncoder.encode((String)WITHLABELS));
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        for (String menu : MENUS) {
            if (!this.contains(menu)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, menu);
            break;
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getByteMrangeParams(String pkey, String startTs, String endTs, ArrayList<ExtsFilter<String>> args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(SafeEncoder.encode((String)pkey));
        byteParams.add(SafeEncoder.encode((String)startTs));
        byteParams.add(SafeEncoder.encode((String)endTs));
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        for (String string : MENUS) {
            if (!this.contains(string)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, string);
            break;
        }
        if (this.contains(WITHLABELS)) {
            byteParams.add(SafeEncoder.encode((String)WITHLABELS));
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        byteParams.add(SafeEncoder.encode((String)FILTER));
        for (ExtsFilter extsFilter : args) {
            byteParams.add(SafeEncoder.encode((String)((String)extsFilter.getFilter())));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getByteMrangeParams(byte[] pkey, byte[] startTs, byte[] endTs, ArrayList<ExtsFilter<byte[]>> args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(pkey);
        byteParams.add(startTs);
        byteParams.add(endTs);
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        for (String string : MENUS) {
            if (!this.contains(string)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, string);
            break;
        }
        if (this.contains(WITHLABELS)) {
            byteParams.add(SafeEncoder.encode((String)WITHLABELS));
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        byteParams.add(SafeEncoder.encode((String)FILTER));
        for (ExtsFilter extsFilter : args) {
            byteParams.add((byte[])extsFilter.getFilter());
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getBytePrangeParams(String pkey, String startTs, String endTs, String pkeyAggregationType, long pkeyTimeBucket, ArrayList<ExtsFilter<String>> args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(SafeEncoder.encode((String)pkey));
        byteParams.add(SafeEncoder.encode((String)startTs));
        byteParams.add(SafeEncoder.encode((String)endTs));
        byteParams.add(SafeEncoder.encode((String)pkeyAggregationType));
        byteParams.add(SafeEncoder.encode((String)String.valueOf(pkeyTimeBucket)));
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        for (String string : MENUS) {
            if (!this.contains(string)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, string);
            break;
        }
        if (this.contains(WITHLABELS)) {
            byteParams.add(SafeEncoder.encode((String)WITHLABELS));
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        byteParams.add(SafeEncoder.encode((String)FILTER));
        for (ExtsFilter extsFilter : args) {
            byteParams.add(SafeEncoder.encode((String)((String)extsFilter.getFilter())));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getBytePrangeParams(byte[] pkey, byte[] startTs, byte[] endTs, byte[] pkeyAggregationType, long pkeyTimeBucket, ArrayList<ExtsFilter<byte[]>> args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(pkey);
        byteParams.add(startTs);
        byteParams.add(endTs);
        byteParams.add(pkeyAggregationType);
        byteParams.add(SafeEncoder.encode((String)String.valueOf(pkeyTimeBucket)));
        if (this.contains(MAXCOUNT)) {
            this.addParamWithValue(byteParams, MAXCOUNT);
        }
        for (String string : MENUS) {
            if (!this.contains(string)) continue;
            byteParams.add(SafeEncoder.encode((String)AGGREGATION));
            this.addParamWithValue(byteParams, string);
            break;
        }
        if (this.contains(WITHLABELS)) {
            byteParams.add(SafeEncoder.encode((String)WITHLABELS));
        }
        if (this.contains(REVERSE)) {
            byteParams.add(SafeEncoder.encode((String)REVERSE));
        }
        byteParams.add(SafeEncoder.encode((String)FILTER));
        for (ExtsFilter extsFilter : args) {
            byteParams.add((byte[])extsFilter.getFilter());
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

