/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairstring.params;

import com.aliyun.tair.jedis3.Params;
import java.util.ArrayList;
import redis.clients.jedis.util.SafeEncoder;

public class ExincrbyParams
extends Params {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";
    private static final String EXAT = "exat";
    private static final String PXAT = "pxat";
    private static final String VER = "ver";
    private static final String ABS = "abs";
    private static final String MAX = "MAX";
    private static final String MIN = "MIN";
    private static final String DEF = "def";
    private static final String NONEGATIVE = "nonegative";
    private static final String KEEPTTL = "keepttl";

    public static ExincrbyParams ExincrbyParams() {
        return new ExincrbyParams();
    }

    public ExincrbyParams def(long defaultValue) {
        this.addParam(DEF, defaultValue);
        return this;
    }

    public ExincrbyParams nonegative() {
        this.addParam(NONEGATIVE);
        return this;
    }

    public ExincrbyParams max(long max) {
        this.addParam(MAX, max);
        return this;
    }

    public ExincrbyParams min(long min) {
        this.addParam(MIN, min);
        return this;
    }

    public ExincrbyParams xx() {
        this.addParam(XX);
        return this;
    }

    public ExincrbyParams nx() {
        this.addParam(NX);
        return this;
    }

    public ExincrbyParams ex(int secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public ExincrbyParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public ExincrbyParams exat(int secondsToExpire) {
        this.addParam(EXAT, secondsToExpire);
        return this;
    }

    public ExincrbyParams pxat(long millisecondsToExpire) {
        this.addParam(PXAT, millisecondsToExpire);
        return this;
    }

    public ExincrbyParams ver(long version) {
        this.addParam(VER, version);
        return this;
    }

    public ExincrbyParams abs(long absoluteVersion) {
        this.addParam(ABS, absoluteVersion);
        return this;
    }

    public ExincrbyParams keepttl() {
        this.addParam(KEEPTTL);
        return this;
    }

    private void addParamWithValue(ArrayList<byte[]> byteParams, String option) {
        if (this.contains(option)) {
            byteParams.add(SafeEncoder.encode((String)option));
            byteParams.add(SafeEncoder.encode((String)String.valueOf(this.getParam(option))));
        }
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (byte[] arg : args) {
            byteParams.add(arg);
        }
        if (this.contains(XX)) {
            byteParams.add(SafeEncoder.encode((String)XX));
        }
        if (this.contains(NX)) {
            byteParams.add(SafeEncoder.encode((String)NX));
        }
        if (this.contains(NONEGATIVE)) {
            byteParams.add(SafeEncoder.encode((String)NONEGATIVE));
        }
        this.addParamWithValue(byteParams, EX);
        this.addParamWithValue(byteParams, PX);
        this.addParamWithValue(byteParams, EXAT);
        this.addParamWithValue(byteParams, PXAT);
        this.addParamWithValue(byteParams, VER);
        this.addParamWithValue(byteParams, ABS);
        this.addParamWithValue(byteParams, MIN);
        this.addParamWithValue(byteParams, MAX);
        this.addParamWithValue(byteParams, DEF);
        if (this.contains(KEEPTTL)) {
            byteParams.add(SafeEncoder.encode((String)KEEPTTL));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

