/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.metrics;

import com.aliyun.tair.tairsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.metrics.Stats;
import com.google.gson.JsonObject;
import java.util.Objects;

public class InternalStats
extends InternalNumericMetricsAggregation.MultiValue
implements Stats {
    protected final long count;
    protected final double min;
    protected final double max;
    protected final double sum;
    protected final double avg;

    public InternalStats(String name, JsonObject in) {
        super(name, in);
        this.count = in.get(Metrics.count.name()).getAsLong();
        this.sum = in.get(Metrics.sum.name()).getAsDouble();
        this.min = in.get(Metrics.min.name()).getAsDouble();
        this.max = in.get(Metrics.max.name()).getAsDouble();
        this.avg = in.get(Metrics.avg.name()).getAsDouble();
    }

    @Override
    public String getWriteableName() {
        throw new IllegalArgumentException("not support stats");
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getAvg() {
        return this.avg;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public String getMinAsString() {
        return this.valueAsString(Metrics.min.name());
    }

    @Override
    public String getMaxAsString() {
        return this.valueAsString(Metrics.max.name());
    }

    @Override
    public String getAvgAsString() {
        return this.valueAsString(Metrics.avg.name());
    }

    @Override
    public String getSumAsString() {
        return this.valueAsString(Metrics.sum.name());
    }

    @Override
    public double value(String name) {
        Metrics metrics = Metrics.valueOf(name);
        switch (metrics) {
            case min: {
                return this.min;
            }
            case max: {
                return this.max;
            }
            case avg: {
                return this.getAvg();
            }
            case count: {
                return this.count;
            }
            case sum: {
                return this.sum;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.count, this.min, this.max, this.sum, this.avg);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalStats other = (InternalStats)obj;
        return this.count == other.count && Double.compare(this.min, other.min) == 0 && Double.compare(this.max, other.max) == 0 && Double.compare(this.sum, other.sum) == 0 && Double.compare(this.avg, other.avg) == 0;
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }
}

