/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.bucket.terms;

import com.aliyun.tair.tairsearch.search.aggregations.BucketOrder;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.IncludeExclude;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.TermsAggregator;
import com.aliyun.tair.tairsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;

public class TermsAggregationBuilder
extends ValuesSourceAggregationBuilder<TermsAggregationBuilder> {
    public static final String NAME = "terms";
    public static final String FIELD_FIELD = "field";
    public static final String ORDER_FIELD = "order";
    public static final String MIN_DOC_COUNT_FIELD = "min_doc_count";
    public static final String INCLUDE_FIELD = "include";
    public static final String EXCLUDE_FIELD = "exclude";
    public static final String SIZE_FIELD = "size";
    static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.BucketCountThresholds(1L, 10);
    private BucketOrder order = BucketOrder.count(false);
    private IncludeExclude includeExclude = null;
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);

    public TermsAggregationBuilder(String name) {
        super(name);
    }

    public TermsAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public int size() {
        return this.bucketCountThresholds.getRequiredSize();
    }

    public TermsAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public long minDocCount() {
        return this.bucketCountThresholds.getMinDocCount();
    }

    public TermsAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public TermsAggregationBuilder includeExclude(IncludeExclude includeExclude) {
        this.includeExclude = includeExclude;
        return this;
    }

    public IncludeExclude includeExclude() {
        return this.includeExclude;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected JsonObject constructInternalJSON() {
        JsonObject termsObject = new JsonObject();
        if (this.field != null) {
            termsObject.addProperty(FIELD_FIELD, this.field);
        }
        termsObject.addProperty(SIZE_FIELD, (Number)this.size());
        termsObject.addProperty(MIN_DOC_COUNT_FIELD, (Number)this.minDocCount());
        if (this.includeExclude != null) {
            if (this.includeExclude.include() != null) {
                termsObject.addProperty(INCLUDE_FIELD, this.includeExclude.include());
            } else if (this.includeExclude.includeValues().size() > 0) {
                JsonArray include = new JsonArray();
                for (String str : this.includeExclude.includeValues()) {
                    include.add(str);
                }
                termsObject.add(INCLUDE_FIELD, (JsonElement)include);
            }
            if (this.includeExclude.exclude() != null) {
                termsObject.addProperty(EXCLUDE_FIELD, this.includeExclude.exclude());
            } else if (this.includeExclude.excludeValues().size() > 0) {
                JsonArray exclude = new JsonArray();
                for (String str : this.includeExclude.excludeValues()) {
                    exclude.add(str);
                }
                termsObject.add(EXCLUDE_FIELD, (JsonElement)exclude);
            }
        }
        termsObject.add(ORDER_FIELD, (JsonElement)this.order.constructJSON());
        return termsObject;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketCountThresholds, this.includeExclude, this.order);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TermsAggregationBuilder other = (TermsAggregationBuilder)obj;
        return Objects.equals(this.bucketCountThresholds, other.bucketCountThresholds) && Objects.equals(this.includeExclude, other.includeExclude) && Objects.equals(this.order, other.order);
    }
}

