/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations;

import com.aliyun.tair.tairsearch.factory.AggregationRegisterFactory;
import com.aliyun.tair.tairsearch.search.aggregations.Aggregation;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Aggregations
implements Iterable<Aggregation> {
    public static final String AGGREGATIONS_FIELD = "aggregations";
    public static final String TYPE_FIELD = "type";
    protected final List<? extends Aggregation> aggregations;
    private Map<String, Aggregation> aggregationsAsMap;
    private JsonObject aggregationsJsonObject;

    public Aggregations(List<? extends Aggregation> aggregations) {
        this.aggregations = aggregations;
        if (aggregations.isEmpty()) {
            this.aggregationsAsMap = Collections.emptyMap();
        }
    }

    public Aggregations(JsonObject in) {
        this.aggregationsJsonObject = in;
        ArrayList<? extends Aggregation> aggregations = new ArrayList<Aggregation>();
        for (Map.Entry entry : in.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonObject()) continue;
            String type = ((JsonObject)value).get(TYPE_FIELD).getAsString();
            aggregations.add(AggregationRegisterFactory.AggregationRegister.get(type).apply(key, (JsonObject)value));
        }
        this.aggregations = aggregations;
        if (aggregations.isEmpty()) {
            this.aggregationsAsMap = Collections.emptyMap();
        }
    }

    @Override
    public final Iterator<Aggregation> iterator() {
        return this.aggregations.stream().map(p -> p).iterator();
    }

    public final List<Aggregation> asList() {
        return Collections.unmodifiableList(this.aggregations);
    }

    public final Map<String, Aggregation> asMap() {
        return this.getAsMap();
    }

    public final Map<String, Aggregation> getAsMap() {
        if (this.aggregationsAsMap == null) {
            HashMap<String, Aggregation> newAggregationsAsMap = new HashMap<String, Aggregation>(this.aggregations.size());
            for (Aggregation aggregation : this.aggregations) {
                newAggregationsAsMap.put(aggregation.getName(), aggregation);
            }
            this.aggregationsAsMap = Collections.unmodifiableMap(newAggregationsAsMap);
        }
        return this.aggregationsAsMap;
    }

    public final <A extends Aggregation> A get(String name) {
        return (A)this.asMap().get(name);
    }

    public final boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.aggregations.equals(((Aggregations)obj).aggregations);
    }

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.aggregations);
    }

    public String toString() {
        return this.aggregationsJsonObject.toString();
    }
}

