/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search;

import com.google.gson.JsonObject;
import java.util.Objects;

public class TotalHits {
    private JsonObject totalHits;
    public final long value;
    public final Relation relation;

    public TotalHits(JsonObject in) {
        this.totalHits = in;
        long value = in.get("value").getAsLong();
        String relation = in.get("relation").getAsString();
        if (value < 0L) {
            throw new IllegalArgumentException("value must be >= 0, got " + value);
        }
        this.value = value;
        if ("eq".equals(relation)) {
            this.relation = Relation.EQUAL_TO;
        } else if ("gte".equals(relation)) {
            this.relation = Relation.GREATER_THAN_OR_EQUAL_TO;
        } else {
            throw new IllegalArgumentException("relation must be eq or gte, got " + value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TotalHits totalHits = (TotalHits)o;
        return this.value == totalHits.value && this.relation == totalHits.relation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.relation});
    }

    public String toString() {
        return this.totalHits.toString();
    }

    public static enum Relation {
        EQUAL_TO,
        GREATER_THAN_OR_EQUAL_TO;

    }
}

