/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.AbstractQueryBuilder;
import com.aliyun.tair.tairsearch.index.query.QueryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BoolQueryBuilder
extends AbstractQueryBuilder<BoolQueryBuilder> {
    public static final String NAME = "bool";
    public static final int DEFAULT_MINIMUM_SHOULD_MATCH = 0;
    private static final String MUST_NOT = "must_not";
    private static final String SHOULD = "should";
    private static final String MUST = "must";
    private static final String MINIMUM_SHOULD_MATCH = "minimum_should_match";
    private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();
    private int minimumShouldMatch = 0;

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> must() {
        return this.mustClauses;
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustNotClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> mustNot() {
        return this.mustNotClauses;
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.shouldClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> should() {
        return this.shouldClauses;
    }

    public int minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public BoolQueryBuilder minimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public boolean hasClauses() {
        return !this.mustClauses.isEmpty() || !this.shouldClauses.isEmpty() || !this.mustNotClauses.isEmpty();
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject newQueryObject = new JsonObject();
        if (!this.mustClauses.isEmpty()) {
            BoolQueryBuilder.constructJSONArray(MUST, this.mustClauses, newQueryObject);
        }
        if (!this.mustNotClauses.isEmpty()) {
            BoolQueryBuilder.constructJSONArray(MUST_NOT, this.mustNotClauses, newQueryObject);
        }
        if (!this.shouldClauses.isEmpty()) {
            BoolQueryBuilder.constructJSONArray(SHOULD, this.shouldClauses, newQueryObject);
        }
        newQueryObject.addProperty(MINIMUM_SHOULD_MATCH, (Number)this.minimumShouldMatch);
        JsonObject queryObject = new JsonObject();
        queryObject.add(NAME, (JsonElement)newQueryObject);
        return queryObject;
    }

    private static void constructJSONArray(String field, List<QueryBuilder> queryBuilders, JsonObject builder) {
        JsonArray queriesJSON = new JsonArray();
        for (QueryBuilder qb : queryBuilders) {
            queriesJSON.add((JsonElement)qb.constructJSON());
        }
        builder.add(field, (JsonElement)queriesJSON);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.minimumShouldMatch, this.mustClauses, this.shouldClauses, this.mustNotClauses);
    }

    @Override
    protected boolean doEquals(BoolQueryBuilder other) {
        return Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.mustClauses, other.mustClauses) && Objects.equals(this.shouldClauses, other.shouldClauses) && Objects.equals(this.mustNotClauses, other.mustNotClauses);
    }
}

