/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ArchiveResource;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.JarResource;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PyResource;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Resource
extends LazyLoad {
    ResourceModel model;
    String project;
    RestClient client;
    Odps odps;

    public Resource() {
        this.model = new ResourceModel();
    }

    Resource(ResourceModel model, String project, Odps odps) {
        this.model = model;
        this.project = project;
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    static Resource createResource(Type type) {
        Resource resource;
        switch (type) {
            case ARCHIVE: {
                resource = new ArchiveResource();
                break;
            }
            case FILE: {
                resource = new FileResource();
                break;
            }
            case JAR: {
                resource = new JarResource();
                break;
            }
            case PY: {
                resource = new PyResource();
                break;
            }
            case TABLE: {
                resource = new TableResource();
                break;
            }
            case UNKOWN: {
                resource = new Resource();
                break;
            }
            default: {
                resource = new Resource();
            }
        }
        return resource;
    }

    static Resource getResource(ResourceModel model, String project, Odps odps) {
        if (model.type == null) {
            Resource resource = new Resource(model, project, odps);
            try {
                resource.reload();
                model = resource.model;
            }
            catch (OdpsException e) {
                return resource;
            }
        }
        Type type = Type.valueOf(model.type.toUpperCase());
        Resource resource = Resource.createResource(type);
        resource.model = model;
        resource.project = project;
        resource.odps = odps;
        resource.client = odps.getRestClient();
        return resource;
    }

    public String getName() {
        if (this.model.name == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.name;
    }

    public void setName(String name) {
        this.model.name = name;
    }

    public String getComment() {
        if (this.model.comment == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public void setComment(String comment) {
        this.model.comment = comment;
    }

    public String getOwner() {
        if (this.model.owner == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Type getType() {
        if (this.model.type == null && this.client != null) {
            this.lazyLoad();
        }
        if (this.model.type == null) {
            return Type.UNKOWN;
        }
        try {
            return Type.valueOf(this.model.type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Type.UNKOWN;
        }
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public String getProject() {
        return this.project;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildResourceResource(this.project, this.model.name);
        Response rp = this.client.request(resource, "HEAD", null, null, null);
        Map<String, String> headers = rp.getHeaders();
        this.model.owner = headers.get("x-odps-owner");
        this.model.type = headers.get("x-odps-resource-type");
        this.model.comment = headers.get("x-odps-comment");
        try {
            this.model.createdTime = DateUtils.parseRfc822Date(headers.get("x-odps-creation-time"));
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(headers.get("Last-Modified"));
        }
        catch (Exception e) {
            throw new OdpsException("Invalid date format", e);
        }
        if (this.model.type.equalsIgnoreCase("table")) {
            this.model.sourceTableName = headers.get("x-odps-copy-table-source");
        } else {
            this.model.contentMD5 = headers.get("Content-MD5");
        }
        this.setLoaded(true);
    }

    @XmlRootElement(name="Resource")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ResourceModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="Comment")
        String comment;
        @XmlElement(name="ResourceType")
        String type;
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date createdTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date lastModifiedTime;
        String sourceTableName;
        String contentMD5;
        boolean isTempResource;

        ResourceModel() {
        }
    }

    public static enum Type {
        FILE,
        JAR,
        PY,
        ARCHIVE,
        TABLE,
        VOLUMEFILE,
        VOLUMEARCHIVE,
        UNKOWN;

    }
}

