/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.model.protobuf;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchDeserializer;
import com.aliyun.datahub.client.http.converter.batch.BatchSerializePool;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordRespMeta;
import com.aliyun.datahub.client.model.protobuf.DatahubProtos;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;

public class GetBatchRecordsResultPB
extends GetRecordsResult
implements BaseProtobufModel {
    private BatchDeserializer deserializer;
    private DatahubProtos.GetBinaryRecordsResponse proto;
    private String shardId;

    public void setDeserializer(BatchDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public static Message.Builder newBuilder() {
        return DatahubProtos.GetBinaryRecordsResponse.newBuilder();
    }

    private List<RecordEntry> convertFromBatchRecord(final DatahubProtos.BinaryRecordEntry binaryRecordPB) {
        byte[] data = binaryRecordPB.getData().toByteArray();
        RecordRespMeta respMeta = new RecordRespMeta(){
            {
                this.setCursor(binaryRecordPB.getCursor());
                this.setNextCursor(binaryRecordPB.getNextCursor());
                this.setSequence(binaryRecordPB.getSequence());
                this.setSystemTime(binaryRecordPB.getSystemTime());
            }
        };
        respMeta.setLatestSequence(this.getLatestSequence());
        respMeta.setLatestTime(this.getLatestTime());
        return this.deserializer.deserialize(data, respMeta, this.shardId);
    }

    public void internalSetShardId(String shardId) {
        this.shardId = shardId;
    }

    @Override
    public String getNextCursor() {
        return this.proto.getNextCursor();
    }

    @Override
    public int getRecordCount() {
        List<RecordEntry> records = this.getRecords();
        return records.size();
    }

    @Override
    public long getStartSequence() {
        return this.proto.getStartSequence();
    }

    @Override
    public long getLatestSequence() {
        return this.proto.getLatestSequence();
    }

    @Override
    public long getLatestTime() {
        return this.proto.getLatestTime();
    }

    @Override
    public synchronized List<RecordEntry> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList();
            ForkJoinPool pool = BatchSerializePool.getReadPool();
            List result = pool == null ? this.proto.getRecordsList().stream().map(this::convertFromBatchRecord).collect(Collectors.toList()) : (List)((ForkJoinTask)pool.submit(() -> this.proto.getRecordsList().parallelStream().map(this::convertFromBatchRecord).collect(Collectors.toList()))).join();
            for (List list : result) {
                this.records.addAll(list);
            }
        }
        return this.records;
    }

    @Override
    public String getContentType() {
        return "application/x-binary";
    }

    @Override
    public Message getMessage() {
        return null;
    }

    @Override
    public void setMessage(Message message) {
        this.proto = (DatahubProtos.GetBinaryRecordsResponse)message;
    }
}

