/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.BinaryParserConfig;
import com.aliyun.datahub.client.model.DelimiterParserConfig;
import com.aliyun.datahub.client.model.InformaticaJsonParserConfig;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class BinaryParserConfigSerializer
extends JsonSerializer<BinaryParserConfig> {
    public void serialize(BinaryParserConfig binaryParserConfig, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        this.serializeBinaryParserConfig(binaryParserConfig, jsonGenerator);
        if (binaryParserConfig instanceof DelimiterParserConfig) {
            this.serializeDelimiterParserConfig((DelimiterParserConfig)binaryParserConfig, jsonGenerator);
        } else if (!(binaryParserConfig instanceof InformaticaJsonParserConfig)) {
            throw new IOException("Unknown binary parser type");
        }
        jsonGenerator.writeEndObject();
    }

    private void serializeBinaryParserConfig(BinaryParserConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (config.getBinaryParserType() != null) {
            jsonGenerator.writeStringField("BinaryParserType", config.getBinaryParserType().name());
        }
        if (config.getColumnNames() != null) {
            jsonGenerator.writeArrayFieldStart("ColumnNames");
            for (String field : config.getColumnNames()) {
                jsonGenerator.writeString(field);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeBooleanField("ParseData", config.isParseData());
    }

    private void serializeDelimiterParserConfig(DelimiterParserConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (config.getLineDelimiter() != null) {
            jsonGenerator.writeStringField("LineDelimiter", config.getLineDelimiter());
        }
        if (config.getColumnDelimiter() != null) {
            jsonGenerator.writeStringField("ColumnDelimiter", config.getColumnDelimiter());
        }
        if (config.getNullValue() != null) {
            jsonGenerator.writeStringField("NullValue", config.getNullValue());
        }
    }
}

