/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.converter.batch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BatchUtil {
    private static final ThreadLocal<ByteBuffer> FOUR_BYTE_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN));
    private static final ThreadLocal<ByteBuffer> EIGHT_BYTE_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN));
    private static final ThreadLocal<byte[]> PADDING_BYTES = ThreadLocal.withInitial(() -> new byte[]{0, 0, 0, 0});

    public static int readInt(byte[] buffer, int pos) {
        ByteBuffer byteBuffer = FOUR_BYTE_BUFFER.get();
        byteBuffer.clear();
        byteBuffer.put(buffer, pos, 4);
        byteBuffer.flip();
        return byteBuffer.getInt();
    }

    public static byte[] parseInt(int value) {
        ByteBuffer byteBuffer = FOUR_BYTE_BUFFER.get();
        byteBuffer.clear();
        byteBuffer.putInt(value);
        return byteBuffer.array();
    }

    public static byte[] parseLong(long value) {
        ByteBuffer byteBuffer = EIGHT_BYTE_BUFFER.get();
        byteBuffer.clear();
        byteBuffer.putLong(value);
        return byteBuffer.array();
    }

    public static byte[] parseFloat(float value) {
        ByteBuffer byteBuffer = EIGHT_BYTE_BUFFER.get();
        byteBuffer.clear();
        byteBuffer.putFloat(value);
        byteBuffer.put(PADDING_BYTES.get());
        return byteBuffer.array();
    }

    public static byte[] parseDouble(double value) {
        ByteBuffer byteBuffer = EIGHT_BYTE_BUFFER.get();
        byteBuffer.clear();
        byteBuffer.putDouble(value);
        return byteBuffer.array();
    }

    public static byte[] parseLittleStr(byte[] bytes) {
        ByteBuffer byteBuffer = EIGHT_BYTE_BUFFER.get();
        int length = bytes.length;
        byteBuffer.clear();
        byteBuffer.put(bytes);
        for (int i = length; i < 7; ++i) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)(bytes.length | 0x80));
        return byteBuffer.array();
    }
}

