/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.converter.batch;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.http.converter.batch.BatchUtil;
import com.aliyun.datahub.client.http.converter.batch.BinaryRecord;
import com.aliyun.datahub.client.model.CompressType;
import com.aliyun.datahub.client.util.CrcUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class BatchBinaryRecord {
    private static final LZ4Compressor LZ4_COMPRESSOR = LZ4Factory.fastestInstance().fastCompressor();
    public static final int BATCH_HEADER_SIZE = 26;
    private static final byte[] MAGIC_NUMBER = new byte[]{68, 72, 85, 66};
    private List<BinaryRecord> records = new ArrayList<BinaryRecord>();

    public void addRecord(BinaryRecord record) {
        this.records.add(record);
    }

    public List<BinaryRecord> getRecords() {
        return this.records;
    }

    public byte[] serialize(CompressType type) {
        try {
            int calSize = 26;
            for (BinaryRecord record : this.records) {
                calSize += record.getRecordSize();
            }
            BatchOutput output = new BatchOutput(calSize, this.records.size());
            for (BinaryRecord record : this.records) {
                record.serialize(output);
            }
            output.compressIfNeed(type);
            return output.toByteArray();
        }
        catch (Exception e) {
            throw new DatahubClientException("Serialize batch record fail. error:" + e.getMessage());
        }
    }

    private static class BatchOutput
    extends ByteArrayOutputStream {
        private final BatchHeader header = new BatchHeader();
        private final int recordCount;

        public BatchOutput(int calSize, int recordCount) {
            super(26 + calSize);
            this.initHeader();
            this.recordCount = recordCount;
        }

        private void initHeader() {
            byte[] buffer = BatchHeader.serialize(this.header);
            this.write(buffer, 0, buffer.length);
        }

        public void compressIfNeed(CompressType type) {
            if (type == null) {
                type = CompressType.NONE;
            }
            int totalSize = this.getRawSize();
            int rawSize = totalSize - 26;
            this.header.setLength(totalSize);
            this.header.setRawSize(rawSize);
            this.header.setAttributes((short)(8 | type.getValue()));
            if (type != CompressType.NONE) {
                byte[] compressData = null;
                try {
                    if (type == CompressType.DEFLATE) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)out, new Deflater(1));
                        dos.write(this.buf, 26, rawSize);
                        dos.close();
                        compressData = out.toByteArray();
                    } else {
                        compressData = LZ4_COMPRESSOR.compress(this.buf, 26, rawSize);
                    }
                    if (compressData.length > rawSize) {
                        this.header.setAttributes((short)(8 | CompressType.NONE.getValue()));
                    } else {
                        System.arraycopy(compressData, 0, this.buf, 26, compressData.length);
                        this.count = 26 + compressData.length;
                        this.header.setLength(this.count);
                    }
                }
                catch (Exception e) {
                    throw new DatahubClientException("Compress data fail. error:" + e.getMessage());
                }
            }
        }

        private int getRawSize() {
            return this.size();
        }

        @Override
        public synchronized byte[] toByteArray() {
            this.header.setMagic(MAGIC_NUMBER);
            this.header.setVersion(0);
            this.header.setRecordCount(this.recordCount);
            int crc32 = CrcUtils.getCrc32(this.buf, 26, this.count - 26);
            this.header.setCrc32(crc32);
            byte[] buffer = BatchHeader.serialize(this.header);
            System.arraycopy(buffer, 0, this.buf, 0, 26);
            return super.toByteArray();
        }
    }

    public static class BatchHeader {
        private static final ThreadLocal<ByteBuffer> BYTE_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(26).order(ByteOrder.LITTLE_ENDIAN));
        private byte[] magic = BatchBinaryRecord.access$000();
        private int version;
        private int length;
        private int rawSize;
        private int crc32;
        private short attributes;
        private int recordCount;

        public byte[] getMagic() {
            return this.magic;
        }

        public void setMagic(byte[] magic) {
            this.magic = magic;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getRawSize() {
            return this.rawSize;
        }

        public void setRawSize(int rawSize) {
            this.rawSize = rawSize;
        }

        public int getCrc32() {
            return this.crc32;
        }

        public void setCrc32(int crc32) {
            this.crc32 = crc32;
        }

        public short getAttributes() {
            return this.attributes;
        }

        public void setAttributes(short attributes) {
            this.attributes = attributes;
        }

        public int getRecordCount() {
            return this.recordCount;
        }

        public void setRecordCount(int recordCount) {
            this.recordCount = recordCount;
        }

        public static BatchHeader parseFrom(byte[] bytes) {
            final ByteBuffer byteBuffer = BYTE_BUFFER.get();
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[26];
            int len = input.read(buffer, 0, 26);
            if (len < 26) {
                throw new DatahubClientException("read batch header fail");
            }
            byteBuffer.clear();
            byteBuffer.put(buffer);
            byteBuffer.flip();
            BatchHeader header = new BatchHeader(){
                {
                    this.setMagic(BatchUtil.parseInt(byteBuffer.getInt()));
                    this.setVersion(byteBuffer.getInt());
                    this.setLength(byteBuffer.getInt());
                    this.setRawSize(byteBuffer.getInt());
                    this.setCrc32(byteBuffer.getInt());
                    this.setAttributes(byteBuffer.getShort());
                    this.setRecordCount(byteBuffer.getInt());
                }
            };
            if (!Arrays.equals(header.getMagic(), MAGIC_NUMBER)) {
                throw new DatahubClientException("Check magic number fail");
            }
            if (bytes.length != header.getLength()) {
                throw new DatahubClientException("Check payload length fail");
            }
            if (header.getCrc32() != 0) {
                int computeCrc = CrcUtils.getCrc32(bytes, 26, header.getLength() - 26);
                if (header.getCrc32() != computeCrc) {
                    throw new DatahubClientException("Check crc fail. expect:" + header.getCrc32() + ", real:" + computeCrc);
                }
            }
            return header;
        }

        public static byte[] serialize(BatchHeader header) {
            ByteBuffer byteBuffer = BYTE_BUFFER.get();
            byteBuffer.clear();
            byteBuffer.put(header.getMagic());
            byteBuffer.putInt(header.getVersion());
            byteBuffer.putInt(header.getLength());
            byteBuffer.putInt(header.getRawSize());
            byteBuffer.putInt(header.getCrc32());
            byteBuffer.putShort(header.getAttributes());
            byteBuffer.putInt(header.getRecordCount());
            return byteBuffer.array();
        }
    }
}

