/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.converter;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.MessageInputStream;
import com.aliyun.datahub.client.http.converter.MessageOutputStream;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class ProtobufConverterFactory
extends Converter.Factory {
    private boolean enablePbCrc;

    public ProtobufConverterFactory(boolean enablePbCrc) {
        this.enablePbCrc = enablePbCrc;
    }

    public static ProtobufConverterFactory create(boolean enableCrc) {
        return new ProtobufConverterFactory(enableCrc);
    }

    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class cls = (Class)type;
        if (!this.isAssignableFrom(cls)) {
            return null;
        }
        return new ProtobufResponseBodyConverter(this.enablePbCrc, cls);
    }

    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class cls = (Class)type;
        if (!this.isAssignableFrom(cls)) {
            return null;
        }
        return new ProtobufRequestBodyConverter(this.enablePbCrc);
    }

    private boolean isAssignableFrom(Class<?> type) {
        return BaseProtobufModel.class.isAssignableFrom(type);
    }

    private static class ProtobufRequestBodyConverter<T extends BaseProtobufModel>
    implements Converter<T, RequestBody> {
        private boolean enablePbCrc;

        public ProtobufRequestBodyConverter(boolean enablePbCrc) {
            this.enablePbCrc = enablePbCrc;
        }

        @Nullable
        public RequestBody convert(T value) throws IOException {
            MediaType mediaType = MediaType.get((String)value.getContentType());
            MessageOutputStream buffer = new MessageOutputStream(this.enablePbCrc);
            Message message = value.getMessage();
            buffer.writeInt(message.getSerializedSize());
            message.writeTo((OutputStream)buffer);
            return RequestBody.create((MediaType)mediaType, (byte[])buffer.toByteArray());
        }
    }

    private static class ProtobufResponseBodyConverter<T extends BaseProtobufModel>
    implements Converter<ResponseBody, T> {
        private static final Map<Class<?>, Method> METHOD_CACHE = new ConcurrentHashMap();
        private boolean enablePbCrc;
        private Class<T> cls;

        public ProtobufResponseBodyConverter(boolean enablePbCrc, Class<T> cls) {
            this.enablePbCrc = enablePbCrc;
            this.cls = cls;
        }

        @Nullable
        public T convert(ResponseBody value) throws IOException {
            try {
                MessageInputStream buffer = new MessageInputStream(value.byteStream(), this.enablePbCrc);
                Message.Builder builder = (Message.Builder)this.getNewBuilder(this.cls).invoke(this.cls, new Object[0]);
                Message message = builder.mergeFrom((InputStream)buffer).build();
                BaseProtobufModel model = (BaseProtobufModel)this.cls.newInstance();
                model.setMessage(message);
                BaseProtobufModel baseProtobufModel = model;
                return (T)baseProtobufModel;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            finally {
                value.close();
            }
        }

        private Method getNewBuilder(Class<T> aClass) throws NoSuchMethodException {
            Method builder = METHOD_CACHE.get(aClass);
            if (builder == null) {
                builder = aClass.getMethod("newBuilder", new Class[0]);
                METHOD_CACHE.put(aClass, builder);
            }
            return builder;
        }
    }
}

