/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http;

import com.aliyun.datahub.client.model.CompressType;
import java.util.Map;
import java.util.Objects;

public class HttpConfig {
    private int readTimeout = 30000;
    private int connTimeout = 30000;
    private int maxRetryCount = 1;
    private int retryIntervalMs = 1000;
    private boolean enableH2C = false;
    private boolean debugRequest = false;
    private CompressType compressType = CompressType.NONE;
    private String proxyUri;
    private String proxyUsername;
    private String proxyPassword;
    private String networkInterface;
    private Map<String, String> userHeader;

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public HttpConfig setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public HttpConfig setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public int getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public HttpConfig setRetryIntervalMs(int retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
        return this;
    }

    public boolean isDebugRequest() {
        return this.debugRequest;
    }

    public HttpConfig setDebugRequest(boolean debugRequest) {
        this.debugRequest = debugRequest;
        return this;
    }

    public boolean isEnableH2C() {
        return this.enableH2C;
    }

    public HttpConfig setEnableH2C(boolean enableH2C) {
        this.enableH2C = enableH2C;
        return this;
    }

    public CompressType getCompressType() {
        return this.compressType;
    }

    public HttpConfig setCompressType(CompressType compressType) {
        this.compressType = compressType;
        return this;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public HttpConfig setProxyUri(String proxyUri) {
        this.proxyUri = proxyUri;
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public HttpConfig setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public HttpConfig setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public HttpConfig setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    public Map<String, String> getUserHeader() {
        return this.userHeader;
    }

    public HttpConfig setUserHeader(Map<String, String> userHeader) {
        this.userHeader = userHeader;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpConfig that = (HttpConfig)o;
        return this.readTimeout == that.readTimeout && this.connTimeout == that.connTimeout && this.enableH2C == that.enableH2C && this.debugRequest == that.debugRequest && this.compressType == that.compressType && Objects.equals(this.proxyUri, that.proxyUri) && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.networkInterface, that.networkInterface);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.readTimeout, this.connTimeout, this.enableH2C, this.debugRequest, this.compressType, this.proxyUri, this.proxyUsername, this.proxyPassword, this.networkInterface});
    }

    public HttpConfig deepCopy() {
        HttpConfig newConfig = new HttpConfig();
        newConfig.setConnTimeout(this.connTimeout);
        newConfig.setReadTimeout(this.readTimeout);
        newConfig.setMaxRetryCount(this.maxRetryCount);
        newConfig.setRetryIntervalMs(this.retryIntervalMs);
        newConfig.setDebugRequest(this.debugRequest);
        newConfig.setEnableH2C(this.enableH2C);
        newConfig.setNetworkInterface(this.networkInterface);
        newConfig.setProxyPassword(this.proxyPassword);
        newConfig.setProxyUri(this.proxyUri);
        newConfig.setProxyUsername(this.proxyUsername);
        newConfig.setCompressType(this.compressType);
        return newConfig;
    }
}

