/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.exception;

public class DatahubClientException
extends RuntimeException {
    private int httpStatus = 5001;
    private String requestId;
    private String traceId;
    private String errorCode;
    private String errorMessage;

    public DatahubClientException(String message, Throwable cause) {
        super(message, cause);
        this.errorMessage = message;
    }

    public DatahubClientException(String message) {
        this(message, null);
    }

    public DatahubClientException(String requestId, String errorCode, String errorMessage) {
        super(errorMessage, null);
        this.requestId = requestId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public DatahubClientException(int httpStatus, String requestId, String errorCode, String errorMessage, Throwable cause) {
        this(httpStatus, requestId, null, errorCode, errorMessage, cause);
    }

    public DatahubClientException(int httpStatus, String requestId, String traceId, String errorCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.httpStatus = httpStatus;
        this.requestId = requestId;
        this.traceId = traceId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public DatahubClientException(int httpStatus, String requestId, String traceId, String errorCode, String errorMessage) {
        this(httpStatus, requestId, traceId, errorCode, errorMessage, null);
    }

    public DatahubClientException(DatahubClientException ex) {
        this(ex.getHttpStatus(), ex.getRequestId(), ex.getTraceId(), ex.getErrorCode(), ex.getErrorMessage());
    }

    public void setHttpStatus(int httpStatus) {
        if (httpStatus != 5001) {
            this.httpStatus = httpStatus;
        }
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getMessage() {
        return "[httpStatus:" + this.httpStatus + ", requestId:" + this.requestId + ", traceId:" + this.traceId + ", errorCode:" + this.errorCode + ", errorMessage:" + this.errorMessage + "]";
    }
}

