/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.CreateSubscriptionResult;
import com.aliyun.datahub.client.model.GetSubscriptionResult;
import com.aliyun.datahub.client.model.ListSubscriptionResult;
import com.aliyun.datahub.client.model.SubscriptionEntry;
import com.aliyun.datahub.client.model.SubscriptionState;

public class SubscriptionExample {
    private static DatahubClient datahubClient;
    private static String subId;

    public static void init() {
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
        subId = "";
    }

    public static void createSubscription() {
        try {
            CreateSubscriptionResult createSubscriptionResult = datahubClient.createSubscription("", "", "");
            System.out.println("create subscription successful");
            System.out.println(createSubscriptionResult.getSubId());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteSubscription() {
        try {
            datahubClient.deleteSubscription("", "", subId);
            System.out.println("delete subscription successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateSubscription() {
        try {
            String newComment = "new subscription comment";
            datahubClient.updateSubscription("", "", subId, newComment);
            System.out.println("update subscription successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void listSubscription() {
        try {
            ListSubscriptionResult listSubscriptionResult = datahubClient.listSubscription("", "", 1, 10);
            if (listSubscriptionResult.getSubscriptions().size() > 0) {
                System.out.println(listSubscriptionResult.getTotalCount());
                System.out.println(listSubscriptionResult.getSubscriptions().size());
                for (SubscriptionEntry entry : listSubscriptionResult.getSubscriptions()) {
                    System.out.println(entry.getSubId() + "\t" + (Object)((Object)entry.getState()) + "\t" + (Object)((Object)entry.getType()) + "\t" + entry.getComment());
                }
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getSubscription() {
        try {
            GetSubscriptionResult getSubscriptionResult = datahubClient.getSubscription("", "", subId);
            System.out.println(getSubscriptionResult.getSubId() + "\t" + (Object)((Object)getSubscriptionResult.getState()) + "\t" + (Object)((Object)getSubscriptionResult.getType()) + "\t" + getSubscriptionResult.getComment());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateSubscriptionState() {
        try {
            datahubClient.updateSubscriptionState("", "", subId, SubscriptionState.ONLINE);
            System.out.println("update subscription state successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        SubscriptionExample.init();
        SubscriptionExample.createSubscription();
    }
}

