/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.common;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class ExpireCache<K, V> {
    private final int expireTime;
    private final int cleanTime = 86400;
    private final List<CacheBucket<V>> bucketList;

    public ExpireCache(int bucketSize, int expireTime) {
        this.bucketList = new ArrayList<CacheBucket<V>>(bucketSize);
        this.expireTime = expireTime;
    }

    public abstract V fetchItem(K var1);

    public V getItem(K key) {
        int index = key.hashCode() % this.bucketList.size();
        CacheBucket<V> bucket = this.bucketList.get(index);
        if (bucket == null) {
            bucket = new CacheBucket(this);
            this.bucketList.add(bucket);
        }
        return bucket.getItem(key);
    }

    public int getExpireTime() {
        return this.expireTime;
    }

    public int getCleanTime() {
        return 86400;
    }

    private static class CacheItem<K, V> {
        private final long lastUpdateTime = System.currentTimeMillis() / 1000L;
        private final ExpireCache<K, V> cache;
        private final Supplier<V> supplier;

        public CacheItem(ExpireCache<K, V> cache, K key, int expireTime) {
            this.cache = cache;
            this.supplier = Suppliers.memoizeWithExpiration(() -> this.cache.fetchItem(key), (long)expireTime, (TimeUnit)TimeUnit.SECONDS);
        }

        public V get() {
            return (V)this.supplier.get();
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }
    }

    private class CacheBucket<V> {
        private final ExpireCache<K, V> cache;
        private long lastCleanTime;
        private final Map<K, CacheItem<K, V>> itemMap;

        public CacheBucket(ExpireCache<K, V> cache) {
            this.cache = cache;
            this.itemMap = new HashMap();
            this.lastCleanTime = System.currentTimeMillis() / 1000L;
        }

        public synchronized V getItem(K key) {
            this.checkClean();
            CacheItem item = this.itemMap.get(key);
            if (item == null) {
                item = new CacheItem(this.cache, key, this.cache.getExpireTime());
                this.itemMap.put(key, item);
            }
            return item.get();
        }

        private void checkClean() {
            long currTime = System.currentTimeMillis() / 1000L;
            if (currTime - this.lastCleanTime > (long)this.cache.getCleanTime()) {
                this.doClean(currTime);
                this.lastCleanTime = currTime;
            }
        }

        private void doClean(long curr) {
            this.itemMap.entrySet().removeIf(entry -> curr - ((CacheItem)entry.getValue()).getLastUpdateTime() > (long)this.cache.getCleanTime());
        }
    }
}

