/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.impl.DatahubClientBatchImpl;
import com.aliyun.datahub.client.impl.DatahubClientJsonImpl;
import com.aliyun.datahub.client.impl.DatahubClientPbImpl;
import com.aliyun.datahub.client.model.CompressType;

public class DatahubClientBuilder {
    private String userAgent;
    private DatahubConfig datahubConfig;
    private HttpConfig httpConfig;

    private DatahubClientBuilder() {
    }

    public static DatahubClientBuilder newBuilder() {
        return new DatahubClientBuilder();
    }

    public DatahubConfig getDatahubConfig() {
        return this.datahubConfig;
    }

    public DatahubClientBuilder setDatahubConfig(DatahubConfig datahubConfig) {
        this.datahubConfig = datahubConfig;
        return this;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public DatahubClientBuilder setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public DatahubClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public DatahubClient build() {
        if (this.datahubConfig == null) {
            throw new InvalidParameterException("DatahubConfig is not set");
        }
        if (this.httpConfig == null) {
            this.httpConfig = new HttpConfig();
        }
        if (this.datahubConfig.isEnableBatch() && (this.httpConfig.getCompressType() == null || this.httpConfig.getCompressType() == CompressType.NONE)) {
            this.httpConfig.setCompressType(CompressType.LZ4);
        }
        if (this.datahubConfig.isEnableSchemaRegistry()) {
            return new DatahubClientBatchImpl(this.datahubConfig.getEndpoint(), this.datahubConfig.getAccount(), this.datahubConfig, this.httpConfig, this.userAgent);
        }
        if (this.datahubConfig.isEnableBinary()) {
            if (this.datahubConfig.isEnableBatch()) {
                return new DatahubClientBatchImpl(this.datahubConfig.getEndpoint(), this.datahubConfig.getAccount(), this.datahubConfig, this.httpConfig, this.userAgent);
            }
            return new DatahubClientPbImpl(this.datahubConfig.getEndpoint(), this.datahubConfig.getAccount(), this.datahubConfig, this.httpConfig, this.userAgent);
        }
        return new DatahubClientJsonImpl(this.datahubConfig.getEndpoint(), this.datahubConfig.getAccount(), this.datahubConfig, this.httpConfig, this.userAgent);
    }
}

