/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader;

import com.alipay.sofa.ark.spi.archive.AbstractArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarBizArchive
extends AbstractArchive
implements BizArchive {
    public final Archive archive;
    private final String SOFA_ARK_BIZ_LIB = "lib/";

    public JarBizArchive(Archive archive) {
        this.archive = archive;
    }

    public URL getUrl() throws MalformedURLException {
        return this.archive.getUrl();
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        Iterator<Archive.Entry> i$ = this.iterator();
        while (i$.hasNext()) {
            Archive.Entry entry = i$.next();
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.archive.getInputStream(zipEntry);
    }

    public Archive getNestedArchive(Archive.Entry entry) throws IOException {
        return this.archive.getNestedArchive(entry);
    }

    public Iterator<Archive.Entry> iterator() {
        return this.archive.iterator();
    }

    public URL[] getUrls() throws IOException {
        return this.getUrls(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return entry.getName().startsWith("lib/");
            }
        });
    }
}

