/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader;

import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.loader.JarContainerArchive;
import com.alipay.sofa.ark.loader.JarPluginArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class ExecutableArkBizJar
implements ExecutableArchive {
    public final String SOFA_ARK_CONTAINER = "SOFA-ARK/container/";
    public final String SOFA_ARK_MODULE = "SOFA-ARK/biz/";
    public final String SOFA_ARK_PLUGIN = "SOFA-ARK/plugin/";
    public final Archive archive;
    public final URL url;

    public ExecutableArkBizJar(Archive archive) {
        this(archive, null);
    }

    public ExecutableArkBizJar(Archive archive, URL url) {
        this.archive = archive;
        this.url = url;
    }

    public URL getUrl() throws MalformedURLException {
        return this.url == null ? this.archive.getUrl() : this.url;
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        Iterator<Archive.Entry> i$ = this.iterator();
        while (i$.hasNext()) {
            Archive.Entry entry = i$.next();
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.archive.getInputStream(zipEntry);
    }

    public Archive getNestedArchive(Archive.Entry entry) throws IOException {
        return this.archive.getNestedArchive(entry);
    }

    public Iterator<Archive.Entry> iterator() {
        return this.archive.iterator();
    }

    public ContainerArchive getContainerArchive() throws Exception {
        List<Archive> archives = this.getNestedArchives(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return "SOFA-ARK/container/".equals(entry.getName());
            }
        });
        if (archives.isEmpty()) {
            throw new RuntimeException("No ark container archive found!");
        }
        return new JarContainerArchive(archives.get(0));
    }

    public List<BizArchive> getBizArchives() throws Exception {
        List<Archive> archives = this.getNestedArchives(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return !entry.getName().equals("SOFA-ARK/biz/") && entry.getName().startsWith("SOFA-ARK/biz/");
            }
        });
        ArrayList<BizArchive> bizArchives = new ArrayList<BizArchive>();
        for (Archive archive : archives) {
            bizArchives.add(new JarBizArchive(archive));
        }
        return bizArchives;
    }

    public List<PluginArchive> getPluginArchives() throws Exception {
        List archives = this.archive.getNestedArchives(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return !entry.getName().equals("SOFA-ARK/plugin/") && entry.getName().startsWith("SOFA-ARK/plugin/");
            }
        });
        ArrayList<PluginArchive> pluginArchives = new ArrayList<PluginArchive>();
        for (Archive archive : archives) {
            pluginArchives.add(new JarPluginArchive(archive));
        }
        return pluginArchives;
    }
}

