/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.bootstrap;

import com.alipay.sofa.ark.bootstrap.ArkLauncher;
import com.alipay.sofa.ark.exception.ArkException;
import com.alipay.sofa.ark.loader.DirectoryBizArchive;
import com.alipay.sofa.ark.loader.DirectoryContainerArchive;
import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.loader.JarContainerArchive;
import com.alipay.sofa.ark.loader.JarPluginArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class ClasspathLauncher
extends ArkLauncher {
    public ClasspathLauncher(ClassPathArchive classPathArchive) {
        super(classPathArchive);
    }

    public static class ClassPathArchive
    implements ExecutableArchive {
        public static final String FILE_IN_JAR = "!/";
        private final String className;
        private final String methodName;
        private final String methodDescription;
        private final URL[] urls;
        private final URLClassLoader urlClassLoader;

        public ClassPathArchive(URL[] urls) {
            this.className = null;
            this.methodName = null;
            this.methodDescription = null;
            this.urls = urls;
            this.urlClassLoader = new URLClassLoader(urls, null);
        }

        public ClassPathArchive(String className, String methodName, String methodDescription, URL[] urls) {
            this.className = className;
            this.methodName = methodName;
            this.methodDescription = methodDescription;
            this.urls = urls;
            this.urlClassLoader = new URLClassLoader(urls, null);
        }

        public List<URL> filterUrls(String resource) throws Exception {
            ArrayList<URL> urlList = new ArrayList<URL>();
            Enumeration<URL> enumeration = this.urlClassLoader.findResources(resource);
            while (enumeration.hasMoreElements()) {
                URL resourceUrl = enumeration.nextElement();
                String resourceFile = resourceUrl.getFile();
                String jarFile = resourceFile.substring(0, resourceFile.length() - resource.length() - FILE_IN_JAR.length());
                urlList.add(new URL(jarFile));
            }
            return urlList;
        }

        public ContainerArchive getContainerArchive() throws Exception {
            ContainerArchive archive = this.getJarContainerArchive();
            if (archive == null) {
                archive = this.createDirectoryContainerArchive();
            }
            if (archive == null) {
                throw new ArkException("No Ark Container Jar File Found.");
            }
            return archive;
        }

        protected ContainerArchive getJarContainerArchive() throws Exception {
            List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/container/mark");
            if (urlList.isEmpty()) {
                return null;
            }
            if (urlList.size() > 1) {
                throw new ArkException("Duplicate Container Jar File Found.");
            }
            return new JarContainerArchive(new JarFileArchive(new File(urlList.get(0).getFile())));
        }

        public List<BizArchive> getBizArchives() throws Exception {
            List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/biz/mark");
            LinkedList<BizArchive> bizArchives = new LinkedList<BizArchive>();
            bizArchives.add(this.createDirectoryBizModuleArchive());
            for (URL url : urlList) {
                bizArchives.add(new JarBizArchive(new JarFileArchive(new File(url.getFile()))));
            }
            return bizArchives;
        }

        public List<PluginArchive> getPluginArchives() throws Exception {
            List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/plugin/mark");
            ArrayList<PluginArchive> pluginArchives = new ArrayList<PluginArchive>();
            for (URL url : urlList) {
                pluginArchives.add(new JarPluginArchive(new JarFileArchive(new File(url.getFile()))));
            }
            return pluginArchives;
        }

        public URL getUrl() {
            throw new RuntimeException("unreachable invocation.");
        }

        public Manifest getManifest() {
            throw new RuntimeException("unreachable invocation.");
        }

        public List<Archive> getNestedArchives(Archive.EntryFilter filter) {
            throw new RuntimeException("unreachable invocation.");
        }

        public Archive getNestedArchive(Archive.Entry entry) {
            throw new RuntimeException("unreachable invocation.");
        }

        public InputStream getInputStream(ZipEntry zipEntry) {
            throw new RuntimeException("unreachable invocation.");
        }

        public Iterator<Archive.Entry> iterator() {
            throw new RuntimeException("unreachable invocation.");
        }

        protected BizArchive createDirectoryBizModuleArchive() {
            return new DirectoryBizArchive(this.className, this.methodName, this.methodDescription, this.urls);
        }

        protected ContainerArchive createDirectoryContainerArchive() {
            URL[] candidates = this.urls.length == 1 ? this.parseClassPathFromSurefireBoot(this.urls[0]) : this.urls;
            URL[] filterUrls = this.filterURLs(candidates);
            return filterUrls == null ? null : new DirectoryContainerArchive(filterUrls);
        }

        protected URL[] filterURLs(URL[] urls) {
            Set<String> arkContainerJarMarkers = DirectoryContainerArchive.getArkContainerJarMarkers();
            HashSet<URL> containerClassPath = new HashSet<URL>();
            for (String marker : arkContainerJarMarkers) {
                for (URL url : urls) {
                    if (!url.getPath().contains(marker)) continue;
                    containerClassPath.add(url);
                }
            }
            return arkContainerJarMarkers.size() != containerClassPath.size() ? null : containerClassPath.toArray(new URL[0]);
        }

        protected URL[] parseClassPathFromSurefireBoot(URL surefireBootJar) {
            try {
                JarFile jarFile = new JarFile(surefireBootJar.getFile());
                String[] classPath = jarFile.getManifest().getMainAttributes().getValue("Class-Path").split(" ");
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : classPath) {
                    urls.add(new URL(path));
                }
                return urls.toArray(new URL[0]);
            }
            catch (IOException ex) {
                throw new ArkException("Parse classpath failed from surefire boot jar.", (Throwable)ex);
            }
        }
    }
}

