/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.bootstrap;

import com.alipay.sofa.ark.bootstrap.ContainerClassLoader;
import com.alipay.sofa.ark.bootstrap.MainMethodRunner;
import com.alipay.sofa.ark.loader.jar.JarFile;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractLauncher {
    public void launch(String[] args) throws Exception {
        JarFile.registerUrlProtocolHandler();
        ClassLoader classLoader = this.createContainerClassLoader(this.getContainerArchive());
        ArrayList<String> attachArgs = new ArrayList<String>();
        attachArgs.add(String.format("%s%s=%s", "-A", "jar", this.getExecutableArchive().getUrl().toExternalForm()));
        attachArgs.addAll(Arrays.asList(args));
        this.launch(attachArgs.toArray(new String[attachArgs.size()]), this.getMainClass(), classLoader);
    }

    public void launch(String[] args, String classpath, Method method) throws Exception {
        JarFile.registerUrlProtocolHandler();
        ClassLoader classLoader = this.createContainerClassLoader(this.getContainerArchive());
        ArrayList<String> attachArgs = new ArrayList<String>();
        attachArgs.add(String.format("%s%s=%s %s %s%s=%s %s %s%s=%s %s %s%s=%s", "-A", "classpath", classpath, "&&", "-B", "className", method.getDeclaringClass().getName(), "&&", "-B", "methodName", method.getName(), "&&", "-B", "methodDescription", method.toGenericString()));
        attachArgs.addAll(Arrays.asList(args));
        this.launch(attachArgs.toArray(new String[attachArgs.size()]), this.getMainClass(), classLoader);
    }

    public Object launch(String classpath) throws Exception {
        JarFile.registerUrlProtocolHandler();
        ClassLoader classLoader = this.createContainerClassLoader(this.getContainerArchive());
        ArrayList<String> attachArgs = new ArrayList<String>();
        attachArgs.add(String.format("%s%s=%s %s %s%s=%s", "-A", "classpath", classpath, "&&", "-B", "runMode", "TEST"));
        return this.launch(attachArgs.toArray(new String[attachArgs.size()]), this.getMainClass(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object launch(String[] args, String mainClass, ClassLoader classLoader) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object object = this.createMainMethodRunner(mainClass, args).run();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected MainMethodRunner createMainMethodRunner(String mainClass, String[] args) {
        return new MainMethodRunner(mainClass, args);
    }

    protected abstract ExecutableArchive getExecutableArchive() throws Exception;

    protected ContainerArchive getContainerArchive() throws Exception {
        return this.getExecutableArchive().getContainerArchive();
    }

    protected ClassLoader createContainerClassLoader(ContainerArchive containerArchive) throws Exception {
        return this.createContainerClassLoader(containerArchive.getUrls(), null);
    }

    protected ClassLoader createContainerClassLoader(URL[] urls, ClassLoader parent) {
        return new ContainerClassLoader(urls, parent);
    }

    protected abstract String getMainClass() throws Exception;
}

