/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.health;

import com.alipay.sofa.healthcheck.startup.SofaBootMiddlewareAfterReadinessCheckCallback;
import com.alipay.sofa.rpc.boot.context.event.SofaBootRpcStartAfterEvent;
import com.alipay.sofa.rpc.boot.context.event.SofaBootRpcStartEvent;
import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import org.slf4j.Logger;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class RpcAfterHealthCheckCallback
implements SofaBootMiddlewareAfterReadinessCheckCallback {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(RpcAfterHealthCheckCallback.class);

    public Health onHealthy(ApplicationContext applicationContext) {
        Health.Builder builder = new Health.Builder();
        try {
            applicationContext.publishEvent((ApplicationEvent)new SofaBootRpcStartEvent(applicationContext));
            applicationContext.publishEvent((ApplicationEvent)new SofaBootRpcStartAfterEvent(applicationContext));
            return builder.status(Status.UP).build();
        }
        catch (Exception e) {
            LOGGER.error("Health check callback error", (Throwable)e);
            return builder.status(Status.DOWN).withDetail("Exception", (Object)e.getMessage()).build();
        }
    }
}

