/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.context;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcParserUtil;
import com.alipay.sofa.rpc.boot.config.FaultToleranceConfigurator;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.boot.container.ProviderConfigContainer;
import com.alipay.sofa.rpc.boot.container.RegistryConfigContainer;
import com.alipay.sofa.rpc.boot.container.ServerConfigContainer;
import com.alipay.sofa.rpc.boot.context.event.SofaBootRpcStartEvent;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.event.LookoutSubscriber;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;

public class SofaBootRpcStartListener
implements ApplicationListener<SofaBootRpcStartEvent> {
    @Autowired
    private SofaBootRpcProperties sofaBootRpcProperties;
    private final ProviderConfigContainer providerConfigContainer;
    private final FaultToleranceConfigurator faultToleranceConfigurator;
    private final ServerConfigContainer serverConfigContainer;
    private final RegistryConfigContainer registryConfigContainer;

    public SofaBootRpcStartListener(ProviderConfigContainer providerConfigContainer, FaultToleranceConfigurator faultToleranceConfigurator, ServerConfigContainer serverConfigContainer, RegistryConfigContainer registryConfigContainer) {
        this.providerConfigContainer = providerConfigContainer;
        this.faultToleranceConfigurator = faultToleranceConfigurator;
        this.serverConfigContainer = serverConfigContainer;
        this.registryConfigContainer = registryConfigContainer;
    }

    public void onApplicationEvent(SofaBootRpcStartEvent event) {
        this.disableLookout();
        this.faultToleranceConfigurator.startFaultTolerance();
        Collection<ProviderConfig> allProviderConfig = this.providerConfigContainer.getAllProviderConfig();
        if (!CollectionUtils.isEmpty(allProviderConfig)) {
            this.serverConfigContainer.startServers();
        }
        this.providerConfigContainer.setAllowPublish(true);
        this.providerConfigContainer.publishAllProviderConfig();
        this.providerConfigContainer.exportAllDubboProvideConfig();
    }

    private void disableLookout() {
        Boolean disable = SofaBootRpcParserUtil.parseBoolean(this.sofaBootRpcProperties.getLookoutCollectDisable());
        if (disable != null) {
            LookoutSubscriber.setLookoutCollectDisable((boolean)disable);
        }
    }
}

