/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.strategy.impl;

import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.PublisherRegister;
import com.alipay.sofa.registry.core.model.RegisterResponse;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.server.session.converter.PublisherConverter;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.remoting.handler.PublisherHandler;
import com.alipay.sofa.registry.server.session.strategy.PublisherHandlerStrategy;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultPublisherHandlerStrategy
implements PublisherHandlerStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublisherHandler.class);
    @Autowired
    private Registry sessionRegistry;

    @Override
    public void handlePublisherRegister(Channel channel, PublisherRegister publisherRegister, RegisterResponse registerResponse) {
        try {
            String ip = channel.getRemoteAddress().getAddress().getHostAddress();
            int port = channel.getRemoteAddress().getPort();
            publisherRegister.setIp(ip);
            publisherRegister.setPort(Integer.valueOf(port));
            if (StringUtils.isBlank((String)publisherRegister.getZone())) {
                publisherRegister.setZone("DEFAULT_ZONE");
            }
            if (StringUtils.isBlank((String)publisherRegister.getInstanceId())) {
                publisherRegister.setInstanceId("DEFAULT_INSTANCE_ID");
            }
            Publisher publisher = PublisherConverter.convert(publisherRegister);
            publisher.setProcessId(ip + ":" + port);
            publisher.setSourceAddress(new URL(channel.getRemoteAddress()));
            if ("REGISTER".equals(publisherRegister.getEventType())) {
                this.sessionRegistry.register((StoreData<String>)publisher);
            } else if ("UNREGISTER".equals(publisherRegister.getEventType())) {
                this.sessionRegistry.unRegister((StoreData<String>)publisher);
            }
            registerResponse.setSuccess(true);
            registerResponse.setVersion(publisher.getVersion().longValue());
            registerResponse.setRegistId(publisherRegister.getRegistId());
            registerResponse.setMessage("Publisher register success!");
            LOGGER.info("Publisher register success!Type:{} Info:{}", (Object)publisherRegister.getEventType(), (Object)publisher);
        }
        catch (Exception e) {
            LOGGER.error("Publisher register error!Type {}", (Object)publisherRegister.getEventType(), (Object)e);
            registerResponse.setSuccess(false);
            registerResponse.setMessage("Publisher register failed!Type:" + publisherRegister.getEventType());
        }
    }
}

