/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.store;

import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.SubscriberResult;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.ReSubscribers;
import com.alipay.sofa.registry.util.VersionsMapUtils;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionInterests
implements Interests,
ReSubscribers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionInterests.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    @Autowired
    private SessionServerConfig sessionServerConfig;
    private ConcurrentHashMap<String, Map<String, Subscriber>> interests = new ConcurrentHashMap();
    private Map<String, Map<String, Subscriber>> connectIndex = new ConcurrentHashMap<String, Map<String, Subscriber>>();
    private Map<SubscriberResult, Map<InetSocketAddress, Map<String, Subscriber>>> resultIndex = new ConcurrentHashMap<SubscriberResult, Map<InetSocketAddress, Map<String, Subscriber>>>();
    private ConcurrentHashMap<String, Map<String, Long>> interestVersions = new ConcurrentHashMap();
    private Map<String, Map<String, Subscriber>> stopPushInterests = new ConcurrentHashMap<String, Map<String, Subscriber>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Subscriber subscriber) {
        this.write.lock();
        try {
            Subscriber existingSubscriber;
            ConcurrentHashMap<String, Subscriber> subscribers = this.interests.get(subscriber.getDataInfoId());
            if (subscribers == null) {
                ConcurrentHashMap<String, Subscriber> newMap = new ConcurrentHashMap<String, Subscriber>();
                subscribers = this.interests.putIfAbsent(subscriber.getDataInfoId(), newMap);
                if (subscribers == null) {
                    subscribers = newMap;
                }
            }
            if ((existingSubscriber = subscribers.get(subscriber.getRegisterId())) != null) {
                LOGGER.warn("There is subscriber already exists,it will be overwrite! {}", (Object)existingSubscriber);
            }
            subscribers.put(subscriber.getRegisterId(), subscriber);
            this.addReSubscriber(subscriber);
            this.addIndex(subscriber);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteById(String registerId, String dataInfoId) {
        this.write.lock();
        try {
            Map<String, Subscriber> subscribers = this.interests.get(dataInfoId);
            if (subscribers == null) {
                LOGGER.error("Delete failed because subscriber is not registered for dataInfoId: {}", (Object)dataInfoId);
                boolean bl = false;
                return bl;
            }
            Subscriber subscriberTodelete = subscribers.remove(registerId);
            if (subscriberTodelete == null) {
                LOGGER.error("Delete failed because subscriber is not registered for registerId: {}", (Object)registerId);
                boolean bl = false;
                return bl;
            }
            if (this.sessionServerConfig.isStopPushSwitch()) {
                this.deleteReSubscriber(subscriberTodelete);
            }
            this.removeIndex(subscriberTodelete);
            boolean bl = true;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteByConnectId(String connectId) {
        this.write.lock();
        try {
            for (Map<String, Subscriber> map : this.interests.values()) {
                Iterator<Subscriber> it = map.values().iterator();
                while (it.hasNext()) {
                    Subscriber subscriber = it.next();
                    if (!connectId.equals(subscriber.getSourceAddress().getAddressString())) continue;
                    it.remove();
                    if (this.sessionServerConfig.isStopPushSwitch()) {
                        this.deleteReSubscriber(subscriber);
                    }
                    this.invalidateIndex(subscriber);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Delete subscriber by connectId {} error!", (Object)connectId, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public long count() {
        AtomicLong count = new AtomicLong(0L);
        for (Map<String, Subscriber> map : this.interests.values()) {
            count.addAndGet(map.size());
        }
        return count.get();
    }

    @Override
    public Map<String, Subscriber> queryByConnectId(String connectId) {
        return this.connectIndex.get(connectId);
    }

    @Override
    public Collection<Subscriber> getInterests(String dataInfoId) {
        Map<String, Subscriber> subscribers = this.interests.get(dataInfoId);
        if (subscribers == null) {
            LOGGER.info("There is not registered subscriber for : {}", (Object)dataInfoId);
            return null;
        }
        return subscribers.values();
    }

    @Override
    public boolean checkInterestVersions(String dataCenter, String dataInfoId, Long version) {
        Long oldValue;
        ConcurrentHashMap newDataInfoVersions;
        Map<String, Subscriber> subscribers = this.interests.get(dataInfoId);
        if (subscribers == null || subscribers.isEmpty()) {
            LOGGER.info("There are not Subscriber Existed! Who are interest with dataInfoId {} !", (Object)dataInfoId);
            return false;
        }
        ConcurrentHashMap dataInfoVersions = this.interestVersions.get(dataCenter);
        if (dataInfoVersions == null && (dataInfoVersions = (ConcurrentHashMap)this.interestVersions.putIfAbsent(dataCenter, newDataInfoVersions = new ConcurrentHashMap())) == null) {
            dataInfoVersions = newDataInfoVersions;
        }
        return (oldValue = dataInfoVersions.get(dataInfoId)) == null || version > oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndUpdateInterestVersions(String dataCenter, String dataInfoId, Long version) {
        this.read.lock();
        try {
            ConcurrentHashMap newDataInfoVersions;
            Map<String, Subscriber> subscribers = this.interests.get(dataInfoId);
            if (subscribers == null || subscribers.isEmpty()) {
                LOGGER.info("There are not Subscriber Existed! Who are interest with dataInfoId {} !", (Object)dataInfoId);
                boolean bl = false;
                return bl;
            }
            ConcurrentHashMap dataInfoVersions = this.interestVersions.get(dataCenter);
            if (dataInfoVersions == null && (dataInfoVersions = (ConcurrentHashMap)this.interestVersions.putIfAbsent(dataCenter, newDataInfoVersions = new ConcurrentHashMap())) == null) {
                dataInfoVersions = newDataInfoVersions;
            }
            boolean bl = VersionsMapUtils.checkAndUpdateVersions(dataInfoVersions, (String)dataInfoId, (Long)version);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Collection<String> getInterestDataInfoIds() {
        return this.interests.keySet();
    }

    private void addIndex(Subscriber subscriber) {
        this.addConnectIndex(subscriber);
        this.addResultIndex(subscriber);
    }

    private void removeIndex(Subscriber subscriber) {
        this.removeConnectIndex(subscriber);
        this.removeResultIndex(subscriber);
    }

    private void invalidateIndex(Subscriber subscriber) {
        this.invalidateConnectIndex(subscriber.getSourceAddress().getAddressString());
        this.invalidateResultIndex(subscriber);
    }

    private void addConnectIndex(Subscriber subscriber) {
        ConcurrentHashMap<String, Subscriber> newSubscriberMap;
        String connectId = subscriber.getSourceAddress().getAddressString();
        ConcurrentHashMap<String, Subscriber> subscriberMap = this.connectIndex.get(connectId);
        if (subscriberMap == null && (subscriberMap = (ConcurrentHashMap<String, Subscriber>)this.connectIndex.putIfAbsent(connectId, newSubscriberMap = new ConcurrentHashMap<String, Subscriber>())) == null) {
            subscriberMap = newSubscriberMap;
        }
        subscriberMap.put(subscriber.getRegisterId(), subscriber);
    }

    private void addResultIndex(Subscriber subscriber) {
        ConcurrentHashMap<String, Subscriber> newSubs;
        InetSocketAddress address;
        ConcurrentHashMap<String, Subscriber> subscribers;
        ConcurrentHashMap<InetSocketAddress, ConcurrentHashMap<String, Subscriber>> newMap;
        SubscriberResult subscriberResult = new SubscriberResult(subscriber.getDataInfoId(), subscriber.getScope());
        ConcurrentHashMap<InetSocketAddress, ConcurrentHashMap<String, Subscriber>> mapSub = this.resultIndex.get(subscriberResult);
        if (mapSub == null && (mapSub = (ConcurrentHashMap<InetSocketAddress, ConcurrentHashMap<String, Subscriber>>)this.resultIndex.putIfAbsent(subscriberResult, newMap = new ConcurrentHashMap<InetSocketAddress, ConcurrentHashMap<String, Subscriber>>())) == null) {
            mapSub = newMap;
        }
        if ((subscribers = (ConcurrentHashMap<String, Subscriber>)mapSub.get(address = new InetSocketAddress(subscriber.getSourceAddress().getIpAddress(), subscriber.getSourceAddress().getPort()))) == null && (subscribers = (Map)mapSub.putIfAbsent(address, newSubs = new ConcurrentHashMap<String, Subscriber>())) == null) {
            subscribers = newSubs;
        }
        subscribers.put(subscriber.getRegisterId(), subscriber);
    }

    private void removeConnectIndex(Subscriber subscriber) {
        String connectId = subscriber.getSourceAddress().getAddressString();
        Map<String, Subscriber> subscriberMap = this.connectIndex.get(connectId);
        if (subscriberMap != null) {
            subscriberMap.remove(subscriber.getRegisterId());
        } else {
            LOGGER.warn("ConnectId {} not existed in Index to remove!", (Object)connectId);
        }
    }

    private void removeResultIndex(Subscriber subscriber) {
        SubscriberResult subscriberResult = new SubscriberResult(subscriber.getDataInfoId(), subscriber.getScope());
        Map<InetSocketAddress, Map<String, Subscriber>> mapSub = this.resultIndex.get(subscriberResult);
        if (mapSub != null) {
            InetSocketAddress address = new InetSocketAddress(subscriber.getSourceAddress().getIpAddress(), subscriber.getSourceAddress().getPort());
            Map<String, Subscriber> subscribers = mapSub.get(address);
            if (subscribers != null) {
                subscribers.remove(subscriber.getRegisterId());
            } else {
                LOGGER.warn("InetSocketAddress {} not existed in Index to remove!", (Object)address);
            }
        } else {
            LOGGER.warn("SubscriberResult {} not existed in Index to remove!", (Object)subscriberResult);
        }
    }

    private void invalidateConnectIndex(String connectId) {
        this.connectIndex.remove(connectId);
    }

    private void invalidateResultIndex(Subscriber subscriber) {
        SubscriberResult subscriberResult = new SubscriberResult(subscriber.getDataInfoId(), subscriber.getScope());
        Map<InetSocketAddress, Map<String, Subscriber>> mapSub = this.resultIndex.get(subscriberResult);
        if (mapSub != null) {
            InetSocketAddress address = new InetSocketAddress(subscriber.getSourceAddress().getIpAddress(), subscriber.getSourceAddress().getPort());
            mapSub.remove(address);
        } else {
            LOGGER.warn("SubscriberResult {} not existed in Index to remove!", (Object)subscriberResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InetSocketAddress, Map<String, Subscriber>> querySubscriberIndex(String dataInfoId, ScopeEnum scope) {
        this.read.lock();
        try {
            SubscriberResult subscriberResult = new SubscriberResult(dataInfoId, scope);
            Map<InetSocketAddress, Map<String, Subscriber>> map = this.resultIndex.get(subscriberResult);
            if (map != null && !map.isEmpty()) {
                ConcurrentHashMap<InetSocketAddress, Map<String, Subscriber>> concurrentHashMap = new ConcurrentHashMap<InetSocketAddress, Map<String, Subscriber>>(map);
                return concurrentHashMap;
            }
            ConcurrentHashMap<InetSocketAddress, Map<String, Subscriber>> concurrentHashMap = new ConcurrentHashMap<InetSocketAddress, Map<String, Subscriber>>();
            return concurrentHashMap;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void addReSubscriber(Subscriber subscriber) {
        if (this.sessionServerConfig.isStopPushSwitch()) {
            ConcurrentHashMap<String, Subscriber> newMap;
            String dataInfoId = subscriber.getDataInfoId();
            ConcurrentHashMap<String, Subscriber> subscriberMap = this.stopPushInterests.get(dataInfoId);
            if (subscriberMap == null && (subscriberMap = (ConcurrentHashMap<String, Subscriber>)this.stopPushInterests.putIfAbsent(dataInfoId, newMap = new ConcurrentHashMap<String, Subscriber>())) == null) {
                subscriberMap = newMap;
            }
            subscriberMap.put(subscriber.getRegisterId(), subscriber);
        }
    }

    @Override
    public boolean deleteReSubscriber(Subscriber subscriber) {
        Map<String, Subscriber> subscribers = this.stopPushInterests.get(subscriber.getDataInfoId());
        if (subscribers == null) {
            return false;
        }
        return subscribers.remove(subscriber.getRegisterId()) != null;
    }

    @Override
    public Map<String, Map<String, Subscriber>> getReSubscribers() {
        return this.stopPushInterests;
    }

    @Override
    public void clearReSubscribers() {
        this.stopPushInterests.clear();
    }

    public SessionServerConfig getSessionServerConfig() {
        return this.sessionServerConfig;
    }

    public void setSessionServerConfig(SessionServerConfig sessionServerConfig) {
        this.sessionServerConfig = sessionServerConfig;
    }
}

