/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.sessionserver.DataPushRequest;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.converter.ReceivedDataConverter;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.scheduler.task.PushTaskClosure;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.task.TaskClosure;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class DataPushTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataPushTask.class);
    private static final Logger taskLogger = LoggerFactory.getLogger(DataPushTask.class, (String)"[Task]");
    private final SessionServerConfig sessionServerConfig;
    private final Interests sessionInterests;
    private final ExecutorManager executorManager;
    private final TaskListenerManager taskListenerManager;
    private DataPushRequest dataPushRequest;

    public DataPushTask(Interests sessionInterests, SessionServerConfig sessionServerConfig, ExecutorManager executorManager, TaskListenerManager taskListenerManager) {
        this.sessionInterests = sessionInterests;
        this.sessionServerConfig = sessionServerConfig;
        this.executorManager = executorManager;
        this.taskListenerManager = taskListenerManager;
    }

    public void execute() {
        String localDataCenterID = this.sessionServerConfig.getSessionServerDataCenter();
        Datum datum = this.dataPushRequest.getDatum();
        if (datum != null) {
            boolean ifLocalDataCenter = localDataCenterID.equals(datum.getDataCenter());
            String dataInfoId = datum.getDataInfoId();
            PushTaskClosure pushTaskClosure = this.getTaskClosure();
            for (ScopeEnum scopeEnum : ScopeEnum.values()) {
                Map<InetSocketAddress, Map<String, Subscriber>> map = this.getCache(scopeEnum, dataInfoId);
                if (map == null || map.isEmpty()) continue;
                block6: for (Map.Entry<InetSocketAddress, Map<String, Subscriber>> entry : map.entrySet()) {
                    Map<String, Subscriber> subscriberMap = entry.getValue();
                    if (subscriberMap == null || subscriberMap.isEmpty()) continue;
                    ArrayList<String> subscriberRegisterIdList = new ArrayList<String>(subscriberMap.keySet());
                    Subscriber subscriber = subscriberMap.values().iterator().next();
                    boolean isOldVersion = !BaseInfo.ClientVersion.StoreData.equals((Object)subscriber.getClientVersion());
                    ArrayList<Subscriber> subscribersSend = new ArrayList<Subscriber>(subscriberMap.values());
                    switch (scopeEnum) {
                        case zone: {
                            if (!ifLocalDataCenter) continue block6;
                            if (isOldVersion) {
                                this.fireUserDataElementPushTask(entry.getKey(), datum, subscribersSend, pushTaskClosure);
                                continue block6;
                            }
                            this.fireReceivedDataMultiPushTask(datum, subscriberRegisterIdList, ScopeEnum.zone, subscriber, pushTaskClosure, subscriberMap);
                            continue block6;
                        }
                        case dataCenter: {
                            if (!ifLocalDataCenter) continue block6;
                            if (isOldVersion) {
                                this.fireUserDataElementMultiPushTask(entry.getKey(), datum, subscribersSend, pushTaskClosure);
                                continue block6;
                            }
                            this.fireReceivedDataMultiPushTask(datum, subscriberRegisterIdList, scopeEnum, subscriber, pushTaskClosure, subscriberMap);
                            continue block6;
                        }
                        case global: {
                            this.fireReceivedDataMultiPushTask(datum, subscriberRegisterIdList, scopeEnum, subscriber, pushTaskClosure, subscriberMap);
                            continue block6;
                        }
                    }
                    LOGGER.warn("unknown scope, {}", (Object)subscriber);
                }
            }
            pushTaskClosure.start();
        }
    }

    public PushTaskClosure getTaskClosure() {
        PushTaskClosure pushTaskClosure = new PushTaskClosure(this.executorManager.getPushTaskClosureExecutor());
        pushTaskClosure.setTaskClosure((status, task) -> {
            if (status == TaskProcessor.ProcessingResult.Success) {
                Datum datum = this.dataPushRequest.getDatum();
                String dataCenter = datum.getDataCenter();
                String dataInfoId = datum.getDataInfoId();
                Long version = datum.getVersion();
                if (this.sessionServerConfig.isStopPushSwitch()) {
                    LOGGER.info("Stop Push switch on,dataCenter {} dataInfoId {} version {} can not be update!", new Object[]{dataCenter, dataInfoId, version});
                    return;
                }
                LOGGER.info("Push all temp data tasks success,dataCenter:{} dataInfoId:{} version:{} update!", new Object[]{dataCenter, dataInfoId, version});
            } else {
                LOGGER.warn("Push temp data tasks found error,subscribers version can not be update!");
            }
        });
        return pushTaskClosure;
    }

    private void fireReceivedDataMultiPushTask(Datum datum, List<String> subscriberRegisterIdList, ScopeEnum scopeEnum, Subscriber subscriber, PushTaskClosure pushTaskClosure, Map<String, Subscriber> subscriberMap) {
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>(subscriberMap.values());
        String dataId = datum.getDataId();
        Predicate<String> zonePredicate = zone -> {
            if (!this.sessionServerConfig.getSessionServerRegion().equals(zone)) {
                if (ScopeEnum.zone == scopeEnum) {
                    return true;
                }
                if (ScopeEnum.dataCenter == scopeEnum && this.sessionServerConfig.isInvalidForeverZone((String)zone) && !this.sessionServerConfig.isInvalidIgnored(dataId)) {
                    return true;
                }
            }
            return false;
        };
        ReceivedData receivedData = ReceivedDataConverter.getReceivedDataMulti(datum, scopeEnum, subscriberRegisterIdList, this.sessionServerConfig.getSessionServerRegion(), zonePredicate);
        HashMap<ReceivedData, URL> parameter = new HashMap<ReceivedData, URL>();
        parameter.put(receivedData, subscriber.getSourceAddress());
        TaskEvent taskEvent = new TaskEvent(parameter, TaskEvent.TaskType.RECEIVED_DATA_MULTI_PUSH_TASK);
        taskEvent.setTaskClosure((TaskClosure)pushTaskClosure);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskLogger.info("send {} taskURL:{},taskScope:{}", new Object[]{taskEvent.getTaskType(), subscriber.getSourceAddress(), scopeEnum});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private Map<InetSocketAddress, Map<String, Subscriber>> getCache(ScopeEnum scopeEnum, String dataInfoId) {
        return this.sessionInterests.querySubscriberIndex(dataInfoId, scopeEnum);
    }

    private void fireUserDataElementPushTask(InetSocketAddress address, Datum datum, Collection<Subscriber> subscribers, PushTaskClosure pushTaskClosure) {
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.USER_DATA_ELEMENT_PUSH_TASK);
        taskEvent.setTaskClosure((TaskClosure)pushTaskClosure);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)new URL(address));
        int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},subSize={}", new Object[]{taskEvent.getTaskType(), address, datum.getDataInfoId(), datum.getDataCenter(), size, subscribers.size()});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void fireUserDataElementMultiPushTask(InetSocketAddress address, Datum datum, Collection<Subscriber> subscribers, PushTaskClosure pushTaskClosure) {
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.USER_DATA_ELEMENT_MULTI_PUSH_TASK);
        taskEvent.setTaskClosure((TaskClosure)pushTaskClosure);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)new URL(address));
        int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},subSize={}", new Object[]{taskEvent.getTaskType(), address, datum.getDataInfoId(), datum.getDataCenter(), size, subscribers.size()});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof DataPushRequest)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.dataPushRequest = (DataPushRequest)obj;
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getDataChangeFetchTaskRetryTimes());
    }

    public String toString() {
        return "DATA_PUSH_TASK{taskId='" + this.getTaskId() + '\'' + ", dataPushRequest=" + this.dataPushRequest + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }
}

