/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.store.DataStore;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.Watchers;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import java.util.ArrayList;
import java.util.List;

public class CancelDataTask
extends AbstractSessionTask {
    private final Interests sessionInterests;
    private final DataStore sessionDataStore;
    private final Watchers sessionWatchers;
    private final DataNodeService dataNodeService;
    private final SessionServerConfig sessionServerConfig;
    private List<String> connectIds;

    public CancelDataTask(Interests sessionInterests, DataStore sessionDataStore, Watchers sessionWatchers, DataNodeService dataNodeService, SessionServerConfig sessionServerConfig) {
        this.sessionInterests = sessionInterests;
        this.sessionDataStore = sessionDataStore;
        this.sessionWatchers = sessionWatchers;
        this.dataNodeService = dataNodeService;
        this.sessionServerConfig = sessionServerConfig;
    }

    public void execute() {
        if (this.connectIds.isEmpty()) {
            throw new IllegalArgumentException("Input clientOff connectIds error!");
        }
        ArrayList<String> connectIdsPub = new ArrayList<String>();
        for (String connectId : this.connectIds) {
            if (this.sessionDataStore.deleteByConnectId(connectId)) {
                connectIdsPub.add(connectId);
            }
            this.sessionInterests.deleteByConnectId(connectId);
            this.sessionWatchers.deleteByConnectId(connectId);
        }
        this.dataNodeService.clientOff(connectIdsPub);
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof List)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.connectIds = (List)obj;
    }

    public String toString() {
        return "CANCEL_DATA_TASK{taskId='" + this.getTaskId() + '\'' + ", connectIds=" + this.connectIds + ", retry='" + this.sessionServerConfig.getCancelDataTaskRetryTimes() + '\'' + '}';
    }

    public boolean checkRetryTimes() {
        return false;
    }
}

