/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.metrics.TaskMetrics;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SessionThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionThreadPoolExecutor.class);
    private String executorName;

    public SessionThreadPoolExecutor(String executorName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.executorName = executorName;
        this.registerTaskMetrics();
    }

    private void registerTaskMetrics() {
        TaskMetrics.getInstance().registerThreadExecutor(this.executorName, (ThreadPoolExecutor)this);
    }

    @Override
    public String toString() {
        return this.executorName + " " + super.toString();
    }

    @Override
    public void execute(Runnable command) {
        try {
            super.execute(command);
        }
        catch (Exception e) {
            if (e instanceof RejectedExecutionException) {
                LOGGER.error("Processor session executor {} Rejected Execution!command {}", new Object[]{this, command.getClass(), e});
            }
            throw e;
        }
    }
}

